#include "tool/tool.h"
#include "gool.h"

#ifdef THEMES_SUPPORT
#include "gool-theme-parts.h"
#include "gool-part-names-ph.h"

//#else
//  #include "gool_theme_ce.h"
//#endif

namespace gool {

  image *theme::get_image(chars name) {
    image *pi = get_image(get_image_id(name));
    if (pi && (pi->get_url().length() == 0))
      pi->set_url(string("theme:") + name);
    return pi;
  }

  uint theme::get_image_id(chars name) {
    const part_def *pd = part_names::find_def(name.start, name.size());
    if (!pd) {
      assert(0);
      return 0;
    }
    return uint(pd - theme_part_defs) + 1;
  }

} // namespace gool

#endif