#include "gool.h"

namespace gool {
  using namespace tool;

  // static handle_pool<image_transformation> all;

  /*uint image_transformation::get_index(const image_transformation& it)
  {
    critical_section _(lock);
    return all[it];
  }
  image_transformation* image_transformation::get(uint idx)
  {
    critical_section _(lock);
    return all(idx);
  }*/

  image *bitmap::transform(const image_filter *ptran) {
    FOREACH(i, transformed_cache) {
      auto it = transformed_cache[i];
      if (it.first->is_equal(ptran)) return it.second;
    }
    handle<bitmap> transformed = new bitmap(this);
    if (transformed) {
      transformed = ptran->apply(transformed);
      transformed_cache.push(bitmap::filter_and_bitmap(ptran, transformed));
      return transformed;
    }
    return this;
  }

  void cvt_grey(bitmap *dst, argb c);
  void cvt_grey(bitmap *dst, argb c0, argb c1, argb c2, argb c3, argb c4);
  void cvt_cbg(bitmap *dst, float contrast, float brightness,
               float gamma_exponent);
  void cvt_colorize(bitmap *dst, argb c);
  void cvt_hue(bitmap *dst, float hue);
  void cvt_opacity(bitmap *dst, float opacity);

  inline float middle(float x, float y) { return (x + y) / 2; }

  const int colorStrong1 = 51;
  const int colorStrong2 = 102;
  const int colorStrong3 = 153;
  const int colorStrong4 = 204;
  const int colorStrong5 = 255;

  void cvt_grey(bitmap *dst, argb base) {
    rgb rgb_base = base;
    hsv hsv_base = rgb_base;

    hsv x1 = hsv_base;
    x1.v   = middle(hsv_base.v, float(colorStrong1) / 256.0f);
    hsv x2 = hsv_base;
    x2.v   = middle(hsv_base.v, float(colorStrong2) / 256.0f);
    hsv x3 = hsv_base;
    x3.v   = middle(hsv_base.v, float(colorStrong3) / 256.0f);
    hsv x4 = hsv_base;
    x4.v   = middle(hsv_base.v, float(colorStrong4) / 256.0f);
    hsv x5 = hsv_base;
    x5.v   = middle(hsv_base.v, float(colorStrong5) /
                                  256.0f); // x5.s = (x5.s + hsvBase.s) / 2;

    argb grey_DarkDark = (rgb(x1));
    argb grey_Dark     = (rgb(x2));
    argb grey_Medium   = (rgb(x3));
    argb grey_Light    = (rgb(x4));
    argb grey_Bright   = (rgb(x5));
    return cvt_grey(dst, grey_DarkDark, grey_Dark, grey_Medium, grey_Light,
                    grey_Bright);
  }

  void cvt_grey(bitmap *dst, argb c0, argb c1, argb c2, argb c3, argb c4) {
    argb grey_colors[256];

    // linear interpolation!
    int i;

    for (i = 0; i <= colorStrong1; i++) {
      grey_colors[i] =
          argb(c0.red * i / colorStrong1, c0.green * i / colorStrong1,
               c0.blue * i / colorStrong1, c0.alfa * i / colorStrong1);
    }
    for (i = colorStrong1 + 1; i <= colorStrong2; i++) {
      grey_colors[i] = argb(int((c1.red - c0.red) * (i - colorStrong1) /
                                (colorStrong2 - colorStrong1)) +
                                c0.red,
                            int((c1.green - c0.green) * (i - colorStrong1) /
                                (colorStrong2 - colorStrong1)) +
                                c0.green,
                            int((c1.blue - c0.blue) * (i - colorStrong1) /
                                (colorStrong2 - colorStrong1)) +
                                c0.blue,
                            int((c1.alfa - c0.alfa) * (i - colorStrong1) /
                                (colorStrong2 - colorStrong1)) +
                                c0.alfa);
    }
    for (i = colorStrong2 + 1; i <= colorStrong3; i++) {
      grey_colors[i] = argb(int((c2.red - c1.red) * (i - colorStrong2) /
                                (colorStrong3 - colorStrong2)) +
                                c1.red,
                            int((c2.green - c1.green) * (i - colorStrong2) /
                                (colorStrong3 - colorStrong2)) +
                                c1.green,
                            int((c2.blue - c1.blue) * (i - colorStrong2) /
                                (colorStrong3 - colorStrong2)) +
                                c1.blue,
                            int((c2.alfa - c1.alfa) * (i - colorStrong2) /
                                (colorStrong3 - colorStrong2)) +
                                c1.alfa);
    }
    for (i = colorStrong3 + 1; i <= colorStrong4; i++) {
      grey_colors[i] = argb(int((c3.red - c2.red) * (i - colorStrong3) /
                                (colorStrong4 - colorStrong3)) +
                                c2.red,
                            int((c3.green - c2.green) * (i - colorStrong3) /
                                (colorStrong4 - colorStrong3)) +
                                c2.green,
                            int((c3.blue - c2.blue) * (i - colorStrong3) /
                                (colorStrong4 - colorStrong3)) +
                                c2.blue,
                            int((c3.alfa - c2.alfa) * (i - colorStrong3) /
                                (colorStrong4 - colorStrong3)) +
                                c2.alfa);
    }
    for (i = colorStrong4 + 1; i <= colorStrong5; i++) {
      grey_colors[i] = argb(int((c4.red - c3.red) * (i - colorStrong4) /
                                (colorStrong5 - colorStrong4)) +
                                c3.red,
                            int((c4.green - c3.green) * (i - colorStrong4) /
                                (colorStrong5 - colorStrong4)) +
                                c3.green,
                            int((c4.blue - c3.blue) * (i - colorStrong4) /
                                (colorStrong5 - colorStrong4)) +
                                c3.blue,
                            int((c4.alfa - c3.alfa) * (i - colorStrong4) /
                                (colorStrong5 - colorStrong4)) +
                                c3.alfa);
    }

    auto xpixel = [&grey_colors](argb &ip) {
      argb p = ip.demultiply();
      // photometric gray representation of rgb:
      uint grey_idx = p.luminance();
      assert(grey_idx < 256);
      // how far the color from gray
      int delta = ((p.red - p.green) * (p.red - p.green) +
                   (p.green - p.blue) * (p.green - p.blue) +
                   (p.blue - p.red) * (p.blue - p.red)) /
                  768;

      if (delta > 16)
        delta = 256;
      else
        delta *= 16;

      argb translated = grey_colors[grey_idx];

      // mix it back
      p.red = translated.red +
              argb::channel_t(delta * (p.red - translated.red) >> 8);
      p.green = translated.green +
                argb::channel_t(delta * (p.green - translated.green) >> 8);
      p.blue = translated.blue +
               argb::channel_t(delta * (p.blue - translated.blue) >> 8);

      ip = p.premultiply();
    };

    dst->foreach_pixel(xpixel);
  }

  void cvt_cbg(bitmap *dst, float contrast, float brightness, float gamma) {
    int        ic, ib;
    array<int> gamma_cache_table;
    bool       use_gamma;

    ic = int(contrast * 256);
    ib = int(brightness * 256) - 128;

    use_gamma = gamma != 1.0f;

    if (use_gamma) gamma_cache_table.length(256, -1);

    auto get_gamma = [&gamma_cache_table, gamma](int i) -> byte {
      i             = limit(i, 0, 255);
      int &gamma_ct = gamma_cache_table[i];
      if (gamma_ct < 0)
        gamma_ct = limit(int(powf(float(i) / 256.0f, gamma) * 256.0f), 0, 255);
      return (byte)gamma_ct;
    };

    auto xpixel = [ic, ib, use_gamma, get_gamma](argb &ip) {
      argb p = ip.demultiply();
      int  r = p.red;
      int  g = p.green;
      int  b = p.blue;

      if (ic != 128) {
        r = ((r - 128) * ic) / 128 + 128;
        g = ((g - 128) * ic) / 128 + 128;
        b = ((b - 128) * ic) / 128 + 128;
      }

      if (ib != 0) {
        r = r + ib;
        g = g + ib;
        b = b + ib;
      }
      if (use_gamma) {
        p.red   = get_gamma(r);
        p.green = get_gamma(g);
        p.blue  = get_gamma(b);

      } else {
        p.red   = (byte)limit(r, 0, 255);
        p.green = (byte)limit(g, 0, 255);
        p.blue  = (byte)limit(b, 0, 255);
      }
      ip = p.premultiply();
    };

    dst->foreach_pixel(xpixel);
  }

  void cvt_opacity(bitmap *dst, float opacity) {
    int a = static_cast<int>(255.0f * limit(opacity, 0.0f, 1.0f));
    if (a == 255) return;

    auto xpixel = [a](argb &p) {
      argb cp = p.demultiply();
      cp.alfa = argb::channel_t((cp.alfa * a) >> 8);
      p       = cp.premultiply();
    };
    dst->foreach_pixel(xpixel);
    dst->_has_alpha_bits = true;
  }

  void cvt_flip_x(bitmap *dst) {
    int rows = dst->dim().y;
    for (int r = 0; r < rows; ++r) {
      slice<argb> row = (*dst)[r];
      argb *      s   = const_cast<argb *>(row.start);
      argb *      l   = const_cast<argb *>(row.end() - 1);
      while (s < l)
        swap(*s++, *l--);
    }
  }
  void cvt_flip_y(bitmap *dst) {
    int         s_row = 0;
    int         l_row = dst->dim().y - 1;
    int         w     = dst->dim().x;
    array<argb> buf(w);
    while (s_row < l_row) {
      buf    = (*dst)[s_row];
      auto s = target(const_cast<argb *>((*dst)[s_row].start), w);
      auto l = target(const_cast<argb *>((*dst)[l_row].start), w);
      s.copy((*dst)[l_row].start, w);
      l.copy(buf.head(), w);
      ++s_row;
      --l_row;
    }
  }

  void cvt_colorize(bitmap *dst, argb c) {
    auto xpixel = [c](argb &p) {
      argb cp      = p.demultiply();
      uint luma    = cp.luminance(); // photometric color->gray (luminescence)
      uint invluma = 255 - luma;
      cp.red       = argb::channel_t(luma + (invluma * c.red >> 8));
      cp.green     = argb::channel_t(luma + (invluma * c.green >> 8));
      cp.blue      = argb::channel_t(luma + (invluma * c.blue >> 8));
      // p.alfa   = luma + (invluma * c.alfa >> 8);
      p = cp.premultiply();
    };
    dst->foreach_pixel(xpixel);
  }

  void cvt_hue(bitmap *dst, float hue) {
    auto xpixel = [&](argb &p) {
      argb      cp = p.demultiply();
      gool::hsv hp = cp;
      hp.h         = hue;
      // hp.s = 0.15f;
      hp.get(cp.red, cp.green, cp.blue);
      p = cp.premultiply();
    };
    dst->foreach_pixel(xpixel);
  }

  void cvt_saturation(bitmap *dst, float sat) {
    auto xpixel = [&](argb &p) {
      argb      cp = p.demultiply();
      gool::hsv hp = cp;
      hp.s         = sat;
      // hp.s = 0.15f;
      hp.get(cp.red, cp.green, cp.blue);
      p = cp.premultiply();
    };
    dst->foreach_pixel(xpixel);
  }

} // namespace gool