#include "gdi+.h"

#if defined(USE_GDI)

#include "tool/tool.h"
#include "gool/gool.h"
#include "gdi+application.h"
#include "html/html.h"
#include "html/html-layout-text-analysis.h"
#include "html/html-layout-text-flow.h"
#include "html/html-view-print.h"

namespace gdi {

  void draw_glyph_run(gool::graphics *gfx, const html::tflow::text_flow &tf,
                      const html::tflow::glyph_run &run, gool::pointf at,
                      argb color, const style *run_style) {
    auto glyphs   = tf._glyph_indices(run.glyph_start, run.glyph_end());
    auto offsets  = tf._glyph_offsets(run.glyph_start, run.glyph_end());
    auto advances = tf._glyph_advances(run.glyph_start, run.glyph_end());

    tool::buffer<PointF, 256> positions(run.glyph_count);
    uint                      flags = 0; // DriverStringOptionsRealizedAdvance;
    float                     rw = 0;
    if ((run.bidi_level & 1) == 0)
      for (uint n = 0; n < run.glyph_count; ++n) {
        positions[n].X = at.x + offsets[n].advance_offset + rw;
        positions[n].Y = at.y + offsets[n].ascender_offset;
        rw += advances[n];
      }
    else {
      rw = 0;
      for (uint n = 0; n < run.glyph_count; ++n) {
        rw -= advances[n];
        positions[n].X = at.x + offsets[n].advance_offset + rw;
        positions[n].Y = at.y + offsets[n].ascender_offset;
      }
    }

    if (run_style->text_shadow.is_defined())
      for (shadow_def *it = run_style->text_shadow; it; it = it->next) {
        gool::argb c = it->color.val(run_style->font_color).to_argb();
        PointF     shadow_offset((float)it->offset_x.pixels(),(float)it->offset_y.pixels());
        // float radius = it.radius.pixels(); - in GDI+ we assume radius  always
        // 0, otherwise it is too hard for the GDI+ to handle this  float spread =
        // it.spread.pixels(); - as it does not support GraphicPath.AddGlyphRun
        // or so.

        tool::buffer<PointF, 256> shadow_positions = positions;
        for (int n = 0; n < shadow_positions.size(); ++n) {
          PointF &pt = shadow_positions[n];
          pt.X += shadow_offset.X;
          pt.Y += shadow_offset.Y;
        }

        SolidBrush fore(g2p(c));

        static_cast<gdi::graphics *>(gfx)->target()->DrawDriverString(
            glyphs.start, glyphs.size(),
            run.font.ptr_of<gdi::font>()->gdi_font(), &fore,
            shadow_positions().start, flags, nullptr);
      }

    SolidBrush fore(g2p(color));

    assert(run.font.ptr_of<gdi::font>()->gdi_font());

    static_cast<gdi::graphics *>(gfx)->target()->DrawDriverString(
        glyphs.start, glyphs.size(), run.font.ptr_of<gdi::font>()->gdi_font(),
        &fore, positions().start, flags, nullptr);
  }

  void window::draw_glyph_run(gool::graphics *              gfx,
                              const html::tflow::text_flow &tf,
                              const html::tflow::glyph_run &run,
                              gool::pointf at, argb color,
                              const style *run_style) {
    gdi::draw_glyph_run(gfx, tf, run, at, color, run_style);
  }

} // namespace gdi

namespace html {
  void print_view::draw_glyph_run(gool::graphics *              gfx,
                                  const html::tflow::text_flow &tf,
                                  const html::tflow::glyph_run &run,
                                  gool::pointf at, argb color,
                                  const html::style *run_style) {
    ///*#ifdef _DEBUG
    //    if(this->page_no == 2 )
    //      gfx = gfx;
    //    if(ln.page_no == 2)
    //      gfx = gfx;
    //#endif*/
    if (this->drawing_content) {
      auto ln = tf.get_line_ref(run.line_no);

      if (ln.page_no && this->page_no != ln.page_no) return;

      range y;
      y.s = int(at.y - ln.baseline);
      y.e = y.s + ln.height;
      if (!page_y.covers(y)) return;
      ln.page_no = uint16(this->page_no);
    }
    gdi::draw_glyph_run(gfx, tf, run, at, color, run_style);
  }

  void print_view::draw_glyph_run_back(gool::graphics *              gfx,
                                       const html::tflow::text_flow &tf,
                                       const html::tflow::glyph_run &run,
                                       gool::rectf rc, argb back_color) {
    if (this->drawing_content) {
      auto ln = tf.get_line(run.line_no);
      if (ln.page_no && this->page_no != ln.page_no) return;
      if (!page_y.covers(rect(rc).y())) return;
      ln.page_no = uint16(this->page_no);
    }
    gfx->fill(back_color, rc);
  }

} // namespace html

#endif