#pragma once

#include "tool/tool.h"
#include "gool/gool.h"
//#include "html/html.h"

#if defined(USE_GDI)

#include "gdi+plus.h"

namespace gdi {

  using namespace tool;
  using namespace gool;
  using namespace Gdiplus;

  class application;

  class window;

  class path : public gool::path, public Gdiplus::GraphicsPath {
  public:
    path() : GraphicsPath(FillModeAlternate) {}
    virtual ~path() {}

    virtual void set(const polygonf &vertices, bool even_odd = true);
    virtual void set(const polygonf &v1, const polygonf &v2);

    virtual bool is_inside(pointf pt);

    virtual void start(pointf start, bool filled);
    virtual void move_to(pointf pt, bool rel = false);
    virtual void line_to(pointf pt, bool rel = false);
    // virtual void hline_to(float x, bool rel = false) {
    // line_to(pointf(x,rel?0:lastp.y),rel); }  virtual void vline_to(float y,
    // bool rel = false) { line_to(pointf(rel?0:lastp.x,y),rel); }
    virtual void  add_arc(pointf c, sizef r, float angle_start, float angle_swipe);
    virtual void  quadratic_to(pointf pt, pointf cp, bool rel = false);
    virtual void  cubic_to(pointf pt, pointf cp1, pointf cp2,
                           bool rel = false); // bezier
    
    virtual void add_round_rect(pointf org, sizef dim, sizef tl, sizef tr, sizef br, sizef bl) {
      gool::path::add_round_rect(org+ pointf(0.5f, 0.5f), dim, tl, tr, br, bl);
    }
    
    virtual rectf bounds() const override;

    
    virtual void set_even_odd(bool yes);
    virtual void close();
    virtual bool is_empty() const { return !_opened; }

    virtual pointf lastp() { return _lastp; }
    virtual void   lastp(pointf p) { _lastp = p; }

    virtual void reset();
    virtual void seal();

  protected:
    bool   _sealed = true;
    bool   _opened = false;
    pointf _firstp;
    pointf _lastp;
  };

  struct font : public gool::font {
    typedef gool::font super;

    font() : super(), hfont(0), _du_ratio(1) {}
    font(const font &f) : super(f), _gdi_font(f._gdi_font), _du_ratio(1) {}
    virtual ~font() {
      if (hfont) ::DeleteObject(hfont);
    }

    virtual bool has_glyph_for(uint ucodepoint) const override;
    virtual uint glyph_index(uint ucodepoint) const override;
    virtual bool glyph_metrics(uint16 glyph_index, float em_size, float &width,
                               float &height) const override {
      return false;
    }

    Gdiplus::Font *gdi_font() const { return _gdi_font; }

    float du2dip(int du) { return du ? du * _du_ratio : 0.0f; }

    HFONT                 hfont;
    handle<Gdiplus::Font> _gdi_font;
    float                 _du_ratio;

    struct char_range {
      wchar  first;
      ushort length;
      bool   operator<(const char_range &other) const {
        return (first + length) < other.first;
      }
    };
    array<char_range> _ranges;
  };

  class graphics : public gool::graphics {
    friend class popup;
    friend class window;
    friend class application;
    typedef gool::graphics super;

  protected:
    gool::point      _offset;
    handle<Graphics> _target;
    tristate_v       _prefer_quality;

    struct layer_t {
      uint                          container_id;
      handle<Gdiplus::Bitmap>       layer_bitmap;
      handle<Gdiplus::Graphics>     layer_original_gfx;
      point                         layer_origin;
      byte                          layer_opacity;
      handle<Gdiplus::GraphicsPath> layer_clip;
      tristate_v                    layer_draw1a;
      handle<bitmap>                layer_mask;
    };
    array<layer_t> _layers;

    struct state_registers {
      UINT state_id;

      float         stroke_width;
      handle<Brush> stroke_brush;

      CAP_STYLE    cap_style;
      LINE_JOIN    line_join;
      DASH_STYLE   dash_style;
      array<float> custom_dash_style;
      float        dash_offset;

      handle<Pen> _stroke_pen;

      handle<Brush> fill_brush;
      bool          fill_even_odd;

      Pen *stroke_pen();

      state_registers()
          : fill_even_odd(true), cap_style(), line_join(), dash_style(),
            stroke_width(), state_id(), dash_offset(0)
      //, container_id()
      //, layer_opacity(255)
      {}
      /*state_registers(const state_registers& rs)
        : state_id(rs.state_id)
        , container_id(rs.container_id)
        , _stroke_pen(rs._stroke_pen)
        , stroke_style(rs.stroke_style)
        , stroke_brush(rs.stroke_brush)
        , stroke_width(rs.stroke_width)
        , cap_style(rs.cap_style)
        , line_join(rs.line_join)
        , fill_brush(rs.fill_brush)
        , fill_even_odd(rs.fill_even_odd)
        , text_format(rs.text_format)
        , dash_style(rs.dash_style)
        , layer_bitmap(rs.layer_bitmap)
        , layer_original_gfx(rs.layer_original_gfx)
        , layer_origin(rs.layer_origin)
        , layer_opacity(rs.layer_opacity)
        , layer_clip(rs.layer_clip)
        {}*/

      bool drawable() const { return stroke_drawable() || fill_drawable(); }
      bool stroke_drawable() const {
        return stroke_brush && stroke_width > 0.0f;
      }
      bool fill_drawable() const { return fill_brush.is_defined(); }
    };

    graphics(): super(false) {}
    graphics(HWND hwnd);
    graphics(Gdiplus::Bitmap *pbm, argb initc = argb(255, 255, 255),
             bool high_quality = false);
    void setup_target();

  public:
    graphics(HDC hdc);
    graphics(gool::bitmap *bmp, argb initc, bool high_quality = false);

    virtual bool needs_half_pixel_adjustment() const override { return true; }

    virtual ~graphics() {}

    Gdiplus::Bitmap *GdiBitmap(bitmap *bmp);
    // HDC hdc()    { return _target->GetHDC(); }
    Graphics *target() { return _target; }
    // void select(gdi::font *pf) { ::SelectObject(hdc(),pf->hfont); }

    virtual void fill(argb c, const rect &dst) override;
    virtual void fill(argb c, const rect &dst, const size &radius) override;
    virtual void fill(argb c, const gool::path *dst) override;
    virtual void fill(const gool::brush *lb, const rect &dst) override;
    // virtual void fill( gool::image* img, const rect& dst, const rect&
    // src,point offset = point(0,0)) override;
    virtual void fill(image *img, const rect &dst, point offset = point(0, 0)) {
      super::fill(img, dst, rect(img->dim()), offset);
    }
    virtual void fill(image *img, const gool::path *dst) override {
#pragma TODO("GDI+ fill( image* img, const gool::path* dst)")
    }

    virtual void draw(const gool::path *dst, argb c,
                      float width = 1.0f) override;

    virtual void draw_line_v(const rect &rc, argb c, int stroke, int step,
                             int_v off) override;
    virtual void draw_line_h(const rect &rc, argb c, int stroke, int step,
                             int_v off) override;

    virtual void draw_line(pointf p1, pointf p2, argb c, int width) override;

    //virtual void draw(gool::text_layout &tl, point dst, argb c) override { draw(tl, pointf(dst), c); }
    //virtual void draw(gool::text_layout &tl, pointf dst, argb c) override;
    //virtual void draw(gool::text_layout &tl, pointf dst) override; // using current fill and stroke

    virtual bool push_clip(const rect &r, clipper *cl);
    virtual void pop_clip();

    virtual point offset(point noff);

    virtual bool set_antialiasing(bool onoff) override;

    virtual gool::path *create_path() const override { return new gdi::path(); }
    virtual gool::application *app() const override;

    virtual uint               push_state();
    virtual bool               pop_state();
    virtual void               restore_state(uint level);

    virtual void push_layer(
        const gool::rect &clip, byte opacity = 255,
        function<bool(filter_graph_builder *)> filters = nullptr) override;
    virtual void push_layer(const gool::path *clip,
                            byte              opacity = 255) override;
    virtual void push_layer(const gool::bitmap *clip, bool draw1a,
                            byte opacity = 255) override;
    virtual void pop_layer() override;
    virtual uint n_layers() override { return uint(_layers.length()); }

    //|
    //| Graphin stuff
    //|

    virtual CAP_STYLE cap_style() override {
      return (CAP_STYLE)_registers.cap_style;
    }
    virtual void cap_style(CAP_STYLE ncs) override {
      _registers._stroke_pen = 0;
      _registers.cap_style   = ncs;
    }
    virtual LINE_JOIN line_join() override {
      return (LINE_JOIN)_registers.line_join;
    }
    virtual void line_join(LINE_JOIN ncs, float mitter_limit = 4) override {
      _registers._stroke_pen = 0;
      _registers.line_join   = ncs;
    }
    virtual DASH_STYLE dash_style() override {
      return (DASH_STYLE)_registers.dash_style;
    }
    virtual void dash_style(DASH_STYLE st) override {
      _registers._stroke_pen = 0;
      _registers.dash_style  = st;
    }
    virtual void custom_dash_style(slice<float> pattern,
                                   float        offset) override {
      _registers.dash_style        = DASH_STYLE_CUSTOM;
      _registers.custom_dash_style = pattern;
      _registers.dash_offset       = offset;
      if (_registers.stroke_width > 0)
        FOREACH(i, _registers.custom_dash_style) {
          _registers.custom_dash_style[i] /= _registers.stroke_width;
        }
      _registers._stroke_pen = 0;
    }

    virtual void set_stroke(argb c = argb::no_color()) override;
    virtual void set_stroke(const linear_brush &lb) override;
    virtual void set_stroke(const radial_brush &rb) override;
    virtual void set_stroke_width(float w) override {
      _registers._stroke_pen  = 0;
      _registers.stroke_width = w;
    }

    virtual void set_fill(argb c = argb::no_color()) override;
    virtual void set_fill(const linear_brush &lb) override;
    virtual void set_fill(const radial_brush &rb) override;
    virtual void set_fill(const image *ib) override;
    virtual void set_fill_even_odd(bool even_odd /*false - non-null*/) override {
      _registers.fill_even_odd = even_odd;
    }

    virtual void draw_ellipse(pointf center, sizef radius, bool stroke = true, bool fill = true) override;
    virtual void draw_arc(pointf center, sizef radius, float angle_start,
                          float angle_sweep, bool stroke = true, bool fill = true) override;
    virtual void draw_rectangle(pointf org, sizef dim, bool stroke = true, bool fill = true) override;
    virtual void draw_rectangle(pointf org, sizef dim, sizef rtl, sizef rtr,
                                sizef rbr, sizef rbl, bool stroke = true, bool fill = true) override {
      super::draw_rectangle(org, dim, rtl, rtr, rbr, rbl,stroke,fill);
    }

    virtual void transform(const affine_mtx_f &m) override;
    virtual void reset_transform() override;
    virtual affine_mtx_f transform() const override;
    virtual void translate(pointf pt) override;
    virtual void rotate(float radians, pointf center = pointf()) override;
    virtual void scale(sizef sz, pointf center = pointf()) override;
    virtual void skew(sizef sz, pointf center = pointf()) override;

    virtual pointf world_to_screen(pointf pt) const override;
    virtual float  world_to_screen(float scalar) const override {
      return super::world_to_screen(scalar);
    }

    virtual pointf screen_to_world(pointf pt) const override;
    virtual float  screen_to_world(float scalar) const override {
      return super::screen_to_world(scalar);
    }

    virtual void draw_path(const gool::path *dst, bool stroke = true, bool fill = true) override;
    virtual void draw_path(const gool::polygonf &p, bool stroke = true, bool fill = true) override;
    virtual void draw_line(pointf start, pointf end) override;
    virtual void draw_line(pointf origin, pointf end, line_end_style sorigin,
                           line_end_style send) override;

    virtual image_renderer_f image_renderer(image *img) override;

  protected:
    virtual void do_draw(image *img, const rectf &dst, const rect &src,
                         byte opacity = 255);

    handle<gool::path>     _path;
    state_registers        _registers;
    array<state_registers> _registers_stack;
  };

  class window_graphics : public graphics {
    // HBITMAP hbitmap;
    // HDC     hdc;
    handle<Bitmap> bitmap;

  public:
    window_graphics(HDC hWndDC) {}
    virtual ~window_graphics();

    virtual void resize(gool::size nsz) override;
  };

  class bitmap_bits_graphics : public graphics {
    handle<gool::bitmap> pbitmap;

  public:
    bitmap_bits_graphics(gool::bitmap *bmp, gool::argb initc, bool high_quality)
        : graphics(bmp, initc, high_quality), pbitmap(bmp) {
      set_clip_rc(rect(bmp->dim()));
    }
    virtual ~bitmap_bits_graphics();
  };

  //#define R2P(R) R.origin.x, R.origin.y, R.width(), R.height()
  inline Color g2p(const gool::argb &c) {
    return Color(c.alfa, c.red, c.green, c.blue);
  }
  inline Rect g2p(const gool::rect &r) {
    return Rect(r.left(), r.top(), r.width(), r.height());
  }
  inline RectF g2p(const gool::rectf &r) {
    return RectF(r.left(), r.top(), r.width(), r.height());
  }
  inline Point  g2p(const gool::point &p) { return Point(p.x, p.y); }
  inline PointF g2p(const gool::pointf &p) { return PointF(p.x, p.y); }
  inline SizeF  g2p(const gool::sizef &p) { return SizeF(p.x, p.y); }

  inline gdi::Matrix *g2p(const gool::affine_mtx_f &s) {
    return new gdi::Matrix(s.sx, s.shy, s.shx, s.sy, s.tx, s.ty);
  }

  inline gool::affine_mtx_f p2g(const gdi::Matrix* mtx) {
    gool::affine_mtx_f s;
    //return new Matrix(s.sx, s.shy, s.shx, s.sy, s.tx, s.ty);
    REAL m[6];
    mtx->GetElements(m);
    s.sx = m[0];
    s.shy = m[1];
    s.shx = m[2];
    s.sy = m[3];
    s.tx = m[4];
    s.ty = m[5];
    return s;
  }


} // namespace gdi

#endif