#ifndef __d2d_h__
#define __d2d_h__

//#include "../config.h"

#include "d2d-primitives.h"

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"

#include "d2d-objects.h"
#include "d2d-graphics.h"
#include "d2d-text-analysis.h"
#include "d2d-application.h"

#if !defined(WINDOWLESS)
  #include "d2d-window.h"
  #include "d2d-bb-window-graphics.h"
#endif

namespace d2d {
  inline IDWriteFactory *dw_factory() {
    d2d::application *pa = gool::app()->cast<d2d::application>();
    assert(pa);
    return pa ? pa->dw_factory() : nullptr;
  }
  inline ID2D1Factory *d2_factory() {
    d2d::application *pa = gool::app()->cast<d2d::application>();
    assert(pa);
    return pa ? pa->d2_factory() : nullptr;
  }
#if defined(WIC_SUPPORT)
  inline IWICImagingFactory *wic_factory() {
    d2d::application *pa = gool::app()->cast<d2d::application>();
    assert(pa);
    return pa ? pa->wic_factory() : nullptr;
  }
#endif
  inline IDWriteFontCollection *fonts_collection() {
    d2d::application *pa = gool::app()->cast<d2d::application>();
    assert(pa);
    return pa  ? pa->fonts_collection() : nullptr;
  }

  application *app_factory();

  inline application *d2d_app() {
    d2d::application *pa = gool::app()->cast<d2d::application>();
    assert(pa);
    return pa;
  }

} // namespace d2d

#endif