#ifndef __d2d_primitives_h__
#define __d2d_primitives_h__

#include "tool/tool.h"
#include "tool/tl_com.h"
#include "gool/gool-geometry.h"
#include "gool/gool-types.h"
#include "gool/gool-affine.h"

#include <specstrings_strict.h>

#if defined(USE_D2D_PLUS)
#include <d2d1_3.h>
#include <d2d1_3helper.h>
#include <d3d11_1.h>
#include <d2d1effects.h>
#include <d2d1effecthelpers.h>
#include <dwrite_3.h>
#else
#include <d2d1.h>
#include <d2d1helper.h>
#include <dwrite.h>
#endif

namespace d2d {

  using namespace com;

  inline gool::size d2g(const D2D1_SIZE_U &s) {
    return gool::size(s.width, s.height);
  }
  inline gool::size d2g(const D2D1_SIZE_F &s) {
    return gool::size(int(s.width), int(s.height));
  }
  inline gool::rect d2g(const D2D1_RECT_U &s) {
    return gool::rect::make_ltrb(s.left, s.top, s.right, s.bottom);
  }
  //inline gool::rect d2g(const D2D1_RECT_F &s) {
  //  return gool::rect(int(s.left), int(s.top), int(s.right),int(s.bottom));
  //}
  inline gool::rectf d2f(const D2D1_RECT_F &s) {
    return gool::rectf::make_ltrb(s.left, s.top, s.right, s.bottom);
  }
  inline gool::pointf d2g(const D2D1_POINT_2F &p) {
    return gool::pointf(p.x, p.y);
  }
  inline gool::point d2g(const D2D1_POINT_2U &p) {
    return gool::point(p.x, p.y);
  }

  inline D2D1_POINT_2U g2u(const gool::point &s) {
    D2D1_POINT_2U t = {uint(s.x), uint(s.y)};
    return t;
  }
  inline D2D1_POINT_2F g2f(const gool::point &s) {
    D2D1_POINT_2F t = {float(s.x), float(s.y)};
    return t;
  }
  inline D2D1_POINT_2F g2f(const gool::pointf &s) {
    D2D1_POINT_2F t = {s.x, s.y};
    return t;
  }

  inline D2D1_SIZE_U g2u(const gool::size &s) {
    D2D1_SIZE_U t = {uint(s.x > 0 ? s.x : 0), uint(s.y > 0 ? s.y : 0)};
    return t;
  }
  inline D2D1_SIZE_F g2f(const gool::size &s) {
    D2D1_SIZE_F t = {float(s.x), float(s.y)};
    return t;
  }
  inline D2D1_SIZE_F g2f(const gool::sizef &s) {
    D2D1_SIZE_F t = {float(s.x), float(s.y)};
    return t;
  }
  inline D2D1_RECT_U g2u(const gool::rect &s) {
    D2D1_RECT_U t = {uint(s.s.x), uint(s.s.y), uint(s.e.x), uint(s.e.y)};
    return t;
  }
  inline D2D1_RECT_F g2f(const gool::rect &s) {
    D2D1_RECT_F t = {float(s.s.x), float(s.s.y),
                     float(s.e.x), float(s.e.y)};
    return t;
  }
  inline D2D1_RECT_F g2f(const gool::rectf &s) {
    D2D1_RECT_F t = {s.s.x, s.s.y, s.e.x, s.e.y};
    return t;
  }

  inline D2D_MATRIX_3X2_F g2f(const gool::affine_mtx_f &s) {
    D2D_MATRIX_3X2_F m;
    m._11 = s.sx;
    m._12 = s.shy;
    m._21 = s.shx;
    m._22 = s.sy;
    m._31 = s.tx;
    m._32 = s.ty;
    return m;
  }

  inline gool::affine_mtx_f f2g(const D2D_MATRIX_3X2_F &m) {
    gool::affine_mtx_f s;
    s.sx  = m._11;
    s.shy = m._12;
    s.shx = m._21;
    s.sy  = m._22;
    s.tx  = m._31;
    s.ty  = m._32;
    return s;
  }


  inline D2D1_COLOR_F g2f(gool::argb cr) {
    D2D1_COLOR_F v;
    v.r = float(cr.red) / 255.0f;
    v.g = float(cr.green) / 255.0f;
    v.b = float(cr.blue) / 255.0f;
    v.a = float(cr.alfa) / 255.0f;
    return v;
  }

} // namespace d2d

#endif