#ifndef __d2d_direct_window_h__
#define __d2d_direct_window_h__

#pragma once

#include "tool/tool.h"
#include "gool/gool.h"
#include "d2d-window.h"
#include "d2d-application.h"

#define BLURBEHIND_SATURATION 2.0f
#define BLURBEHIND_BLUR_DEVIATION 40

EXTERN_DLOADV(_DwmGetWindowAttribute, DwmGetWindowAttribute, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hwnd, DWORD dwAttribute, _Out_ LPVOID pvAttribute, DWORD cbAttribute));

//EXTERN_DLOADV(_DwmGetCompositionTimingInfo, DwmGetCompositionTimingInfo, dwmapi.dll,
//  HRESULT(WINAPI *)(HWND hwnd, DWM_TIMING_INFO *pTimingInfo));

EXTERN_DLOADV(_DwmFlush, DwmFlush, dwmapi.dll,
  HRESULT(WINAPI *)());

#if defined(USE_DIRECT_COMP)

namespace d2d {

  typedef NTSTATUS(WINAPI* RtlGetVersionPtr)(PRTL_OSVERSIONINFOW);
  typedef BOOL(WINAPI* SetWindowCompositionAttributeP)(IN HWND hwnd, IN WINDOWCOMPOSITIONATTRIBDATA* pwcad);
  typedef HRESULT(WINAPI* DwmpCreateSharedThumbnailVisual)(IN HWND hwndDestination, IN HWND hwndSource, IN DWORD dwThumbnailFlags, IN DWM_THUMBNAIL_PROPERTIES* pThumbnailProperties, IN VOID* pDCompDevice, OUT VOID** ppVisual, OUT PHTHUMBNAIL phThumbnailId);
  typedef HRESULT(WINAPI* DwmpCreateSharedMultiWindowVisual)(IN HWND hwndDestination, IN VOID* pDCompDevice, OUT VOID** ppVisual, OUT PHTHUMBNAIL phThumbnailId);
  typedef HRESULT(WINAPI* DwmpUpdateSharedMultiWindowVisual)(IN HTHUMBNAIL hThumbnailId, IN HWND* phwndsInclude, IN DWORD chwndsInclude, IN HWND* phwndsExclude, IN DWORD chwndsExclude, OUT RECT* prcSource, OUT SIZE* pDestinationSize, IN DWORD dwFlags);
  typedef HRESULT(WINAPI* DwmpCreateSharedVirtualDesktopVisual)(IN HWND hwndDestination, IN VOID* pDCompDevice, OUT VOID** ppVisual, OUT PHTHUMBNAIL phThumbnailId);
  typedef HRESULT(WINAPI* DwmpUpdateSharedVirtualDesktopVisual)(IN HTHUMBNAIL hThumbnailId, IN HWND* phwndsInclude, IN DWORD chwndsInclude, IN HWND* phwndsExclude, IN DWORD chwndsExclude, OUT RECT* prcSource, OUT SIZE* pDestinationSize);

  namespace Dwm {
    extern DwmpCreateSharedThumbnailVisual   CreateSharedThumbnailVisual;
    extern DwmpCreateSharedMultiWindowVisual CreateSharedMultiWindowVisual;
    extern DwmpUpdateSharedMultiWindowVisual UpdateSharedMultiWindowVisual;
    extern DwmpCreateSharedVirtualDesktopVisual CreateSharedVirtualDesktopVisual;
    extern DwmpUpdateSharedVirtualDesktopVisual UpdateSharedVirtualDesktopVisual;
    extern SetWindowCompositionAttributeP SetWindowCompositionAttribute;
    extern RtlGetVersionPtr GetVersionInfo;
    bool init();
  };

  enum BACKDROP_SOURCE
  {
    BACKDROP_SOURCE_DESKTOP = 0x0,
    BACKDROP_SOURCE_HOSTBACKDROP = 0x1
  };

  //class direct_window;
    
  class window_bb_graphics : public window_graphics_dxgi {
    friend class application;
    friend class direct_window;
    typedef window_graphics_dxgi super;

  protected:

    window_bb_graphics(html::iwindow* pw, bool transparent, GRAPHICS_CAPS caps, bool for_layered);

  public:
    static window_bb_graphics *create(html::iwindow* pw, bool is_transparent, GRAPHICS_CAPS caps, bool for_layered);

    virtual ~window_bb_graphics();

    bool is_blurbehind() const { return !!clip; }

    void resize(gool::size nsz) {
      //super::resize(nsz);

#if 0      
      HRESULT hr = _swap_chain->ResizeBuffers(0, nsz.x, nsz.y, DXGI_FORMAT_UNKNOWN, 0);

      com::asset<ID2D1DeviceContext> dc = device_context();

      dc->SetTarget(nullptr);

      HR(_swap_chain->GetBuffer(0, __uuidof(fallback_surface), reinterpret_cast<void**>(fallback_surface.target())));

      D2D1_BITMAP_PROPERTIES1 properties = {};

      properties.pixelFormat.alphaMode = D2D1_ALPHA_MODE_PREMULTIPLIED;
      properties.pixelFormat.format = DXGI_FORMAT_B8G8R8A8_UNORM;
      properties.bitmapOptions = D2D1_BITMAP_OPTIONS_TARGET | D2D1_BITMAP_OPTIONS_CANNOT_DRAW;
      HR(dc->CreateBitmapFromDxgiSurface(fallback_surface, properties, _bitmap.target()));

      dc->SetTarget(_bitmap);
      dc->SetDpi(96.0, 96.0); // we do DIPs by ourselves

      //device_context()->BeginDraw();
      //device_context()->Clear();
      //device_context()->CreateSolidColorBrush(tintColor, fallbackBrush.GetAddressOf());
      //device_context()->FillRectangle(desktop_area, fallbackBrush.Get());
      //device_context()->EndDraw();
      //if (_swap_chain->Present(1, 0) != S_OK)
      //{
      //  return false;
      //}

      device_context(dc);
#endif      
      set_clip_rc(nsz);

    }

    virtual void end_drawing() override {
      auto const hr = _swap_chain->Present(1, 0);
      if ((S_OK != hr) && (DXGI_STATUS_OCCLUDED != hr))
        release_device();
    }
        
    virtual void commit() {
      dcomp_device->Commit();
      _DwmFlush()();
    }

    virtual void on_window_position_change() override ;
    virtual void on_window_active_state_change(bool active) override;
    
  protected:
    virtual bool create_device() override {
      //return _window->get_blurbehind()
      //  ? 
      return create_device_blurbehind();
      //return create_device_plain();
    }
    bool create_device_plain();
    bool create_device_blurbehind();
    
    RECT desktop_area;
    bool create_backdrop(BACKDROP_SOURCE source);
    bool create_composition_visual();
    bool create_fallback_visual();

    virtual bool create_device_swap_chain_bitmap() override {
      return true;
    }

    void set_transparency(bool on_off);

    com::asset<IDCompositionDesktopDevice> dcomp_device;

    com::asset<IDCompositionTarget>  composition_target;
    com::asset<IDCompositionVisual2> root_visual;
    com::asset<IDCompositionVisual2> background_visual;
    com::asset<IDCompositionVisual2> fallback_visual;
    com::asset<ID2D1SolidColorBrush> fallback_brush;

    com::asset<IDXGISurface2>        fallback_surface;

    com::asset<IDCompositionVisual2> desktop_window_visual;
    com::asset<IDCompositionVisual2> toplevel_window_visual;
    array<HWND>                      window_exclusion_list;

    com::asset<IDCompositionTranslateTransform> translate_transform;
    com::asset<IDCompositionRectangleClip>      clip;
    HTHUMBNAIL                       toplevel_window_thumbnail = nullptr;

  };

  extern application *d2d_app();
  
  inline void window_bb_graphics::set_transparency(bool on_off)
  {
    _transparent = on_off;
  }
  
}

#endif // defined(USE_DIRECT_COMP)

#endif
