#pragma once

#include "d2d/d2d-objects.h"
#include "d2d/d2d-primitives.h"
#include "d2d/d2d-graphics.h"
#include "d2d/d2d-font-loader.h"

#if !defined(WINDOWLESS)
  #include "win/win-application.h"
  #include "win/win-frame.h"
  typedef mswin::application application_base_t;
  typedef mswin::window window_processor_t;
#else
  #include "lite/lite-view.h"
  #include "lite/lite-application.h"
  typedef lite::application application_base_t;
  typedef lite::view window_processor_t;
#endif

namespace d2d 
{
  class application
      : public application_base_t
  {
    friend application *app_factory();

    typedef application_base_t super;

  public:
    DEFINE_TYPE_ID_DERIVED(application,application_base_t)

    virtual void final_release() override;

    ID2D1Factory *d2_factory() const {
#ifdef USE_D2D_PLUS
      if (_D2_1_factory) return _D2_1_factory;
#endif
      return _D2_factory;
    }
    IDWriteFactory *dw_factory() const {
      return _DW_factory;
    }

#ifdef USE_D2D_PLUS
    ID2D1Factory1 *  d2_1_factory() const { return _D2_1_factory; }
    ID2D1Factory2 *  d2_1_factory2() const { return _D2_1_factory2; }
#endif

    IDWriteFontCollection *fonts_collection() const {
      return p_fonts_collection;
    }

  public:
    virtual bool is_valid() override {
      return d2_factory() && dw_factory()
#ifdef WIC_SUPPORT
             && wic_factory()
#endif
          ;
    }
    virtual bool is_d2d() override { return true; }

    virtual bool supports_filters() const {
#if defined(USE_D2D_PLUS)
      return !!_D2_1_factory;
#else
      return false;
#endif
    } // true if the platform is capable of filters

    virtual bool supports_printing() const override {
#if defined(USE_D2D_PLUS)
      return !!_D2_1_factory;
#else
      return false;
#endif
    }

    virtual tool::ustring
    get_supported_font(const tool::ustring &family_name_list, int weight,
                       bool                               italic,
                       d2d::asset<IDWriteFontCollection> &found_in);

    virtual tool::ustring
    get_supported_font_family(const tool::ustring &family_name_list) override {
      d2d::asset<IDWriteFontCollection> dummy;
      return get_supported_font(family_name_list, 400, false, dummy);
    }

    virtual bool install_font(const tool::ustring &name, int weight,
                              bool italic, tool::bytes data) override;

    virtual bool get_used_font(tool::handle<gool::font> &pf,
                               tool::wchars              family_name_list,
                               const gool::font *proto, tool::wchars lang_id,
                               WRITING_SCRIPT script, uint char_code = 0);

    virtual ~application();

    virtual gool::font *create_font(const ustring &name, float size,
                                    uint weight, bool italic,
                                    FONT_RENDERING mode);
    virtual void        clear_font_cache() override;
    virtual gool::path *create_path();

    virtual window_processor_t* create_window_processor(const window_params &params) override;

#if !defined(WINDOWLESS)

    virtual window_processor_t* create_dx_window_processor(const window_params &params, IDXGISwapChain *pSwapChain) override;

    virtual handle<html::view> create_frame(const window_params &params) override;
    virtual handle<html::view> create_dialog(const window_params &params) override;
#endif

    virtual gool::graphics *create_bitmap_graphics(gool::graphics* proto, gool::bitmap*  bmp, gool::argb initc) override;
    virtual gool::graphics *create_bitmap_bits_graphics(gool::bitmap *pb, gool::argb initc, bool high_quality = false) override;

    virtual bool construct_font_collection_for(memory_font_variant &fv) override;

    virtual bool each_font_family(function<bool(wchars name)>  cb, function<void(ucode, ucode)> cb_ranges) override;

    ustring get_font_family_for_ucode(uint char_code);

    virtual GRAPHICS_CAPS graphics_caps() const override;

#if !defined(WINDOWLESS)
    virtual gool::application *        printing_app() override;
    virtual handle<gool::print_target> create_print_target();
    virtual html::print_view*          create_print_processor(const window_params& params) override;
#endif
    virtual void draw_glyph_run(html::view *pv, gool::graphics *gfx,
      const html::tflow::text_flow &tf,
      const html::tflow::glyph_run &gr,
      gool::pointf at, argb color,
      const html::style *run_style);

    d2d::ResourceFontContext font_loading_context;
#if defined(USE_D2D_PLUS)
    ID3D11Device*               device_3d();
    IDCompositionDesktopDevice* dcomp_device();

#endif
  protected:
    application();

    virtual bool init_font(gool::font *pf);

    d2d::asset<ID2D1Factory>   _D2_factory;
    d2d::asset<IDWriteFactory> _DW_factory;
#ifdef USE_D2D_PLUS
    //d2d::asset<IDWriteFactory1> _DW_1_factory;
    d2d::asset<ID2D1Factory1>   _D2_1_factory;
    d2d::asset<ID2D1Factory2>   _D2_1_factory2;

    d2d::asset<ID3D11Device>               _device_3D;
    d2d::asset<IDCompositionDesktopDevice> _device_dcomp;

#endif
    d2d::asset<IDWriteFontCollection> p_fonts_collection;
    handle_pool<d2d::font>            _fonts;

  };

#ifdef USE_D2D_PLUS
  class application_plus : public application 
  {
    typedef application super;

  public:
    virtual void draw_glyph_run(html::view *pv, gool::graphics *gfx,
      const html::tflow::text_flow &tf,
      const html::tflow::glyph_run &gr,
      gool::pointf at, argb color,
      const html::style *run_style) override;

    d2d::asset<IDWriteFactory4> _dw_factory4;

  };
#endif

} // namespace d2d