
#ifdef SCITERJS
  #include "sdk.js/include/sciter-x-dom.h"
#else
  #include "sdk/include/sciter-x-dom.h"
#endif
#include "html/html.h"
#include "api/ext-ctl-api.h"

using namespace tool;

html::element *element_ptr(HELEMENT he) { return he; }

inline HELEMENT element_handle(html::element *pe) { return pe; }

SCDOM_RESULT SCAPI Sciter_UseElement_api(HELEMENT he) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  b->ext_add_ref();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI Sciter_UnuseElement_api(HELEMENT he) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  b->ext_release();
  return SCDOM_OK;
}

#define EXEC_START(p) pview->exec([&r,pview,p]() -> bool {
#define EXEC_START_2(p1, p2) pview->exec([&r,pview,p1,p2]() -> bool {
#define EXEC_START_3(p1, p2, p3) pview->exec([&r,pview,p1,p2,p3]() -> bool {
#define EXEC_START_4(p1, p2, p3, p4) pview->exec([&r,pview,p1,p2,p3,p4]() -> bool {
#define EXEC_START_5(p1, p2, p3, p4, p5) pview->exec([&r,pview,p1,p2,p3,p4,p5]() -> bool {
#define EXEC_END                                                               \
  return true;                                                                 \
  });

SCDOM_RESULT SCAPI SciterGetRootElement_api(HWINDOW hwnd, HELEMENT *phe) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!phe) return SCDOM_INVALID_PARAMETER;
  // critical_section cs(pview->guard);

  SCDOM_RESULT r = SCDOM_OK;

  EXEC_START(phe)
  *phe = element_handle(pview->doc());
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetFocusElement_api(HWINDOW hwnd, HELEMENT *phe) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!phe) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;

  EXEC_START(phe)
  *phe = element_handle(pview->focus_element.ptr());
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetElementUID_api(HELEMENT he, UINT *puid) {
  if (!puid) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  *puid = b->uid;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetHighlightedElement_api(HWINDOW   hwnd,
                                                   HELEMENT *phe) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!phe) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START(phe)
  *phe = element_handle(pview->get_highlighted());
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSetHighlightedElement_api(HWINDOW hwnd, HELEMENT he) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START(he)
  handle<html::element> b = element_ptr(he);
  pview->set_highlighted(b);
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetElementByUID_api(HWINDOW hwnd, UINT uid,
                                             HELEMENT *phe) {
  get_pview(hwnd);
  if (!phe) return SCDOM_INVALID_PARAMETER;

  if (!pview) return SCDOM_INVALID_HWND;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(uid, phe)
  html::node *b = pview->doc()->get_node_by_uid(uid);
  if (!b || !b->is_element())
    r = SCDOM_OPERATION_FAILED;
  else
    *phe = b->cast<element>();
  EXEC_END
  return r;
}

//|
//| SciterFindElement
//|
SCDOM_RESULT SCAPI SciterFindElement_api(HWINDOW hwnd, POINT pt,
                                         HELEMENT *phe) {
  get_pview(hwnd);
  if (!pview) return SCDOM_INVALID_HWND;
  if (!phe) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(pt, phe)

  html::element *b = pview->find_element(gool::point(pt.x, pt.y));
  if (b)
    *phe = element_handle(b);
  else
    *phe = 0;

  EXEC_END
  return r;
}

//|
//| SciterGetParentElement
//|
SCDOM_RESULT SCAPI SciterGetParentElement_api(HELEMENT  he,
                                              HELEMENT *p_parent_he) {
  if (!p_parent_he) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::element>  bp = b->dom_parent();

  if (bp)
    *p_parent_he = element_handle(bp);
  else
    *p_parent_he = 0;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetChildrenCount_api(HELEMENT he, UINT *count) {
  if (!count) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  *count = b->n_children();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetElementType_api(HELEMENT he, LPCSTR *p_type) {
  if (!p_type) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  *p_type = html::tag::symbol_name(b->tag);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetElementTypeCB_api(HELEMENT he, LPCSTR_RECEIVER *rcv,
                                              LPVOID rcv_param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  tool::string tag = html::tag::symbol_name(b->tag);
  rcv(tag.c_str(), UINT(tag.length()), rcv_param);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetNthChild_api(HELEMENT he, UINT n, HELEMENT *phe) {
  if (!phe) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  if (n < (UINT)b->n_children()) {
    *phe = element_handle(b->child(n));
    return SCDOM_OK;
  }
  return SCDOM_INVALID_PARAMETER;
}

SCDOM_RESULT SCAPI SciterGetElementIndex_api(HELEMENT he, LPUINT p_index) {
  if (!p_index) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  *p_index = b->index();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetElementHtmlCB_api(HELEMENT he, SBOOL outer,
                                              LPCBYTE_RECEIVER *rcv,
                                              LPVOID            param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  html::ostream_8 os;

  if (outer)
    b->emit(os);
  else
    b->emit_content(os);

  os.data.push(0);
  os.data.pop();

  rcv(os.data.head(), os.data.size(), param);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetElementTextCB_api(HELEMENT          he,
                                              LPCWSTR_RECEIVER *rcv,
                                              LPVOID            rcv_param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) {
    array<wchar> data;
    b->emit_text(data);
    data.push(0);
    data.pop();
    rcv(data.head(), data.size(), rcv_param);
  }
  else {
    ustring data = b->get_text(*pview);
    rcv(data.c_str(), data.size(), rcv_param);
  }
    
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterSetElementText_api(HELEMENT he, LPCWSTR utf16words,
                                            UINT length) {
  // if(!utf16words)
  //  return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, utf16words, length)

  if (utf16words)
    b->set_text(*pview, wchars(utf16words, length));
  else
    b->clear(pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetAttributeCount_api(HELEMENT he, UINT *count) {
  if (!count) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  *count = b->atts.size();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetNthAttribute_api(HELEMENT he, UINT n,
                                             LPCSTR *p_name, LPCWSTR *p_value) {
  /*if(!p_name && !p_value)
    return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if(!b)
    return SCDOM_INVALID_HANDLE;
  if(n >= UINT(b->atts.size()))
    return SCDOM_INVALID_PARAMETER;
  if(p_name)
     *p_name = b->atts.name(n);
  if(p_value)
     *p_value = b->atts.value(n);
  */
  return SCDOM_OPERATION_FAILED;
}

SCDOM_RESULT SCAPI SciterGetNthAttributeNameCB_api(HELEMENT he, UINT n,
                                                   LPCSTR_RECEIVER *rcv,
                                                   LPVOID           rcv_param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  if (n >= UINT(b->atts.size())) return SCDOM_INVALID_PARAMETER;

  tool::string name = b->atts.name(n);
  rcv(name.c_str(), UINT(name.length()), rcv_param);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetNthAttributeValueCB_api(HELEMENT he, UINT n,
                                                    LPCWSTR_RECEIVER *rcv,
                                                    LPVOID rcv_param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  if (n >= UINT(b->atts.size())) return SCDOM_INVALID_PARAMETER;

  tool::ustring val = b->atts.value(n);
  rcv(val.c_str(), UINT(val.length()), rcv_param);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetAttributeByName_api(HELEMENT he, LPCSTR name,
                                                LPCWSTR *p_value) {
  return SCDOM_OPERATION_FAILED;
}

SCDOM_RESULT SCAPI SciterGetAttributeByNameCB_api(HELEMENT he, LPCSTR name,
                                                  LPCWSTR_RECEIVER *rcv,
                                                  LPVOID            rcv_param) {
  if (!name || !rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  if (!b->atts.exist(name)) return SCDOM_OK_NOT_HANDLED;
  tool::ustring val = b->atts(name);
  rcv(val.c_str(), UINT(val.length()), rcv_param);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterSetAttributeByName_api(HELEMENT he, LPCSTR name,
                                                LPCWSTR value) {
  if (!name) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  html::name_or_symbol ns(name);

  handle<html::view> pview = b->pview();
  if (!pview) {
    if (value)
      b->set_attr(ns, value);
    else
      b->remove_attr(ns);
    return SCDOM_OK;
  } else {
    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START_3(b, ns, value)
    if (value)
      b->set_attr(ns, value);
    else
      b->remove_attr(ns);
    EXEC_END
    return r;
  }
}

SCDOM_RESULT SCAPI SciterClearAttributes_api(HELEMENT he) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  b->atts.clear();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetStyleAttributeCB_api(HELEMENT he, LPCSTR name,
                                                 LPCWSTR_RECEIVER *rcv,
                                                 LPVOID            rcv_param) {
  if (!rcv) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, name, rcv, rcv_param)
  ustring val = b->get_style(*pview)->to_value(name).to_string();
  rcv(val, UINT(val.length()), rcv_param);
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSetStyleAttribute_api(HELEMENT he, LPCSTR name,
                                               LPCWSTR value) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, name, value)
  if (!name) {
    b->a_style = 0;
    pview->add_to_update(b, false);
  } else if (value) {
    ustring v(value);
    b->set_style_attribute(name, v);
  } else {
    //b->remove_style_attribute(name);
    b->set_style_attribute(name, tool::value());
  }
  EXEC_END
  return r;
}

RECT api_cvt(gool::rect rc) {
  RECT r;
  r.left   = rc.left();
  r.top    = rc.top();
  r.right  = rc.right() + 1;
  r.bottom = rc.bottom() + 1;
  return r;
}

POINT api_cvt(gool::point pt) {
  POINT p;
  p.x = pt.x;
  p.y = pt.y;
  return p;
}

SIZE api_cvt(gool::size sz) {
  SIZE p;
  p.cx = sz.x;
  p.cy = sz.y;
  return p;
}

SCDOM_RESULT SCAPI SciterGetElementLocation_api(HELEMENT he, LPRECT p_location,
                                                UINT areas) {
  if (!p_location) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, p_location, areas)

  gool::rect r(b->dim());
  //++r.origin;
  //++r.corner; - ERROR! it gets converted in api_cvt() below

  uint a   = areas & 0xF0;
  int  rel = areas & 0xF;

  switch (a) {
  case CONTENT_BOX: break;
  case PADDING_BOX: r = b->padding_box(*pview); break;
  case BORDER_BOX: r = b->border_box(*pview); break;
  case MARGIN_BOX: r = b->margin_box(*pview); break;
  case BACK_IMAGE_AREA: {
    // html::hstyle cs = b->get_style(*pview);
    // r = //b->image_z_box(*pview,cs->back_image);
  } break;
  case FORE_IMAGE_AREA:
    if (b->ldata.is_defined()) {
      // html::hstyle cs = b->get_style(*pview);
      // r = b->image_z_box(*pview,cs->fore_image);
      r = b->ldata->foreground_box;
    }
    break;
  case SCROLLABLE_AREA: {
    rect t = b->client_rect(*pview);
    t += r.s;
    r = t;
  } break;
  }

  if (rel == 0) {
    r += b->doc_pos(*pview);
    html::element *scb = b->get_windowed_container(*pview);
    if (scb) r -= scb->doc_pos(*pview);
  } else if (rel == ROOT_RELATIVE) {
    r += b->doc_pos(*pview);
  } else if (rel == CONTAINER_RELATIVE) {
    r += b->pos();
  } else if (rel == SELF_RELATIVE) {
    ;
  } else if (rel == VIEW_RELATIVE)
    r += b->view_pos(*pview);

  *p_location = api_cvt(r);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterScrollToView_api(HELEMENT                     he,
                                          UINT /*SCITER_SCROLL_FLAGS*/ flags) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();

  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, flags)

  pview->commit_update();
  html::ENSURE_VISIBLE_MANNER how = html::SCROLL;
  if (flags & ::SCROLL_SMOOTH) how = html::SCROLL_SMOOTH;
  pview->ensure_visible(b, (flags & SCROLL_TO_TOP) != 0, how);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterCombineURL_api(HELEMENT he, LPWSTR szUrlBuffer,
                                        UINT UrlBufferSize) {
  if (!szUrlBuffer || !UrlBufferSize) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  html::document *d = b->doc();
  if (!d) return SCDOM_PASSIVE_HANDLE;

  string in  = ustring(szUrlBuffer);
  string out = html::combine_url(d->uri().src, in);

  ustring uout(out);
  int     sz = min(uout.size(), int(UrlBufferSize) - 1);
#ifdef WINDOWS
  wcsncpy_s(szUrlBuffer, UrlBufferSize, uout.c_str(), sz);
#else
  std::size_t length = sz < UrlBufferSize ? sz : (UrlBufferSize - 1);
  std::copy_n(uout.c_str(), length, szUrlBuffer);
  szUrlBuffer[length] = 0;
#endif

  szUrlBuffer[sz] = 0;

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterGetElementHwnd_api(HELEMENT he, HWINDOW *p_hwnd,
                                            SBOOL rootWindow) {
  if (!p_hwnd) return SCDOM_INVALID_PARAMETER;

  handle<html::element> el = element_ptr(he);
  if (!el) return SCDOM_INVALID_HANDLE;

  html::document *d = el->doc();
  if (!d) return SCDOM_PASSIVE_HANDLE;

  handle<html::view> pview = d->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  if (rootWindow) el = d;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(el, p_hwnd)

  html::element *b = el;

  while (b) {
    html::iwindow *iw = b->window(*pview);
    if (iw) {
      *p_hwnd = iw->get_hwnd();
      r       = SCDOM_OK;
      return true;
    }
    b = b->parent;
  }
  *p_hwnd = 0;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterRefreshElementArea_api(HELEMENT he, RECT rc) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  // html::layout_view* pview = (html::layout_view*)b->host();

  handle<html::view> pview = b->pview();

  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, rc)

  gool::rect gr(rc.left, rc.top, rc.right - 1, rc.bottom - 1);
  pview->refresh(b, gr);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSetCapture_api(HELEMENT he) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HWND;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START(b)

  pview->set_capture(b);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterReleaseCapture_api(HELEMENT he) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();

  if (!pview) return SCDOM_INVALID_HWND;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START(b)

  pview->set_capture(0);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterUpdateElement_api(HELEMENT he,
                                           SBOOL     forceUpdateWindow) {

  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HWND;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, forceUpdateWindow)

  b->reset_styles(*pview);
  pview->to_update.update(pview);
  b->check_layout(*pview);
  b->commit_measure(*pview);
  pview->refresh(b);

  if (forceUpdateWindow) {
    iwindow *pw = b->get_window(*pview, true);
    if (pw) pw->update();
  }

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSelectElementsW_api(HELEMENT he, LPCWSTR selector,
                                             SciterElementCallback *callback,
                                             LPVOID                 param) {
  if (!callback) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();

  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, selector, callback, param)

  html::selector_context sctx(b, chars_of(selector), false);
  element_iterator_ctx   it(*pview, b, sctx);

  for (element *bf; it(bf);) {
    if (callback(element_handle(bf), param)) break;
  }
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSelectElements_api(HELEMENT he, LPCSTR selector,
                                            SciterElementCallback *callback,
                                            LPVOID                 param) {
  tool::ustring sel(selector);
  return SciterSelectElementsW_api(he, sel, callback, param);
}

SCDOM_RESULT SCAPI SciterSelectParentW_api(HELEMENT he, LPCWSTR selector,
                                           UINT              depth,
                                           /*out*/ HELEMENT *heFound) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  if (!heFound || !selector) return SCDOM_INVALID_PARAMETER;
  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, selector, depth, heFound)

  *heFound =
      (HELEMENT)html::find_first_parent(*pview, b, chars_of(selector), depth);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSelectParent_api(HELEMENT he, LPCSTR selector,
                                          UINT              depth,
                                          /*out*/ HELEMENT *heFound) {
  tool::ustring sel(selector);
  return SciterSelectParentW_api(he, sel, depth, heFound);
}

SCDOM_RESULT SCAPI SciterSetElementHtml_api(HELEMENT he, LPCBYTE htmlBytes,
                                            UINT htmlLength, UINT where) {
  if (!htmlBytes || !htmlLength) return SCDOM_INVALID_PARAMETER;

  handle<html::element> pel = element_ptr(he);
  if (!pel) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = pel->pview();

  if (!pview) return SCDOM_INVALID_HWND;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(pel, htmlBytes, htmlLength, where)

  tool::bytes    html(htmlBytes, htmlLength);
  html::helement b = pel;

  switch (where) {
  case SIH_REPLACE_CONTENT:
    r = pview->set_element_html(b, html, html::SE_REPLACE)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  case SIH_INSERT_AT_START:
    r = pview->set_element_html(b, html, html::SE_INSERT)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  case SIH_APPEND_AFTER_LAST:
    r = pview->set_element_html(b, html, html::SE_APPEND)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  case SOH_REPLACE:
    r = pview->set_element_html(b, html, html::SE_OUTER_REPLACE)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  case SOH_INSERT_BEFORE:
    r = pview->set_element_html(b, html, html::SE_OUTER_INSERT_BEFORE)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  case SOH_INSERT_AFTER:
    r = pview->set_element_html(b, html, html::SE_OUTER_INSERT_AFTER)
            ? SCDOM_OK
            : SCDOM_OPERATION_FAILED;
    break;
  }

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetElementState_api(HELEMENT he, UINT *pstateBits) {
  if (!pstateBits) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  *pstateBits = (UINT)b->get_state(false).data;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterSetElementState_api(HELEMENT he, UINT stateBitsToSet,
                                             UINT stateBitsToClear,
                                             SBOOL updateView) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  /*
  stateBitsToSet &= html::PUBLIC_STATE_BITMASK; - covers UINT in full
  stateBitsToClear &= html::PUBLIC_STATE_BITMASK;
  */

  handle<html::view> pview = b->pview();

  if (pview) {
    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START_4(b, stateBitsToSet, stateBitsToClear, updateView)
    if (stateBitsToSet) b->set_state(html::ui_state(stateBitsToSet), pview);
    if (stateBitsToClear)
      b->reset_state(html::ui_state(stateBitsToClear), pview);
    EXEC_END
    return r;
  } else {
    if (stateBitsToSet) b->set_state(html::ui_state(stateBitsToSet), 0);
    if (stateBitsToClear) b->reset_state(html::ui_state(stateBitsToClear), 0);
  }
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterCreateElement_api(LPCSTR tag, LPCWSTR text,
                                           /*out*/ HELEMENT *phe) {
  if (!tag || !phe) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = new html::element(html::tag::symbol(tag));
  if (!b) return SCDOM_OPERATION_FAILED;
  if (text && text[0]) b->append(new html::text(chars_of(text)));
  b->ext_add_ref();
  *phe = b;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterCloneElement_api(HELEMENT he, /*out*/ HELEMENT *phe) {
  html::element *src = element_ptr(he);
  if (!src) return SCDOM_INVALID_HANDLE;
  if (!phe) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = static_cast<html::element *>(src->clone());
  b->parent               = 0;
  b->ext_add_ref();
  *phe = b;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterInsertElement_api(HELEMENT he, HELEMENT hparent,
                                           UINT index) {
  html::helement b  = element_ptr(he);
  html::helement bp = element_ptr(hparent);
  if (!b || !bp) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = bp->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, bp, index)

  if (int(index) >= bp->n_children())
    bp->append(b, pview);
  else
    bp->insert(bp->child(index)->node_index, b, pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterDetachElement_api(HELEMENT he) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!b->parent) return SCDOM_OK;

  html::helement     bp    = b->parent;
  handle<html::view> pview = bp->pview();

  if (pview) {
    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START_2(b, bp)

    if (b->get_ref_count() == 1)
      b->stray(*pview); // reference is held by outer world only
    b->remove(true);
    pview->add_to_update(bp, true);

    EXEC_END
    return r;
  } else
    b->remove(false);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterDeleteElement_api(HELEMENT he) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();

  if (pview) {
    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START(b)
    if(b->parent)
      pview->add_to_update(b->parent, true);
    b->remove(true,pview);
    EXEC_END
    return r;
  } else
    b->remove(true);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterSetTimer_api(HELEMENT he, UINT millis,
                                      UINT_PTR timer_id) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, millis, timer_id)

  if (millis)
    pview->start_timer(b, millis, timer_id, html::EXTERNAL_TIMER);
  else
    pview->stop_timer(b, timer_id, html::EXTERNAL_TIMER);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterAttachEventHandler_api(HELEMENT          he,
                                                ElementEventProc *pep,
                                                LPVOID            tag) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, pep, tag)

  ext_ctl *nb = new ext_ctl(pep, tag);
  b->attach_behavior(*pview, nb);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterDetachEventHandler_api(HELEMENT          he,
                                                ElementEventProc *pep,
                                                LPVOID            tag) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, pep, tag)

  html::ctl *t     = b->behavior;
  html::ctl *found = 0;
  for (; t; t = t->next)
    if (t->is_ext()) {
      ext_ctl *ec = static_cast<ext_ctl *>(t);
      if (ec->pep == pep && ec->tag == tag) {
        found = ec;
        break;
      }
    }

  if (found) b->detach_behavior(*pview, found);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterFireEvent_api(const BEHAVIOR_EVENT_PARAMS *pevt,
                                       SBOOL post, SBOOL *handled) {
  html::helement b = element_ptr(pevt->heTarget);
  if (!b) goto POST_TO_ALL_WINDOWS;

  {
    handle<html::view> pview = b->pview();
    if (!pview) return SCDOM_PASSIVE_HANDLE;

    SCDOM_RESULT r = SCDOM_OK;

    html::helement src = element_ptr(pevt->he);

    html::event_behavior evt(b, src, pevt->cmd, pevt->reason);
    evt.data = tool::value(*(tool::value *)&pevt->data);
    evt.name = pevt->name;

    bool ret = false;
    if (post)
      pview->post_behavior_event(evt);
    else {
      EXEC_START_3(b, &evt, &ret)
        ret = pview->send_behavior_event(evt);
      EXEC_END
    }

    if (handled) *handled = ret ? TRUE : FALSE;

    return r;
  }

POST_TO_ALL_WINDOWS: 
  {
    html::helement src = element_ptr(pevt->he);
    html::event_behavior evt(src, nullptr, pevt->cmd, pevt->reason);
    evt.data = tool::value(*(tool::value *)&pevt->data);
    evt.name = pevt->name;

    SCDOM_RESULT r = SCDOM_OK;
    bool ret = false;
    if (post) {
      //pview->post_behavior_event(evt);
      html::view::each([&evt](handle<html::view> hv) {
        hv->post_behavior_event(evt, true);
      });
    }
    else {
        //ret = pview->send_behavior_event(evt);
        html::view::each([&r,&evt, &ret](handle<html::view> pview) {
          EXEC_START_2(&evt, &ret)
            bool done = pview->send_behavior_event(evt);
            ret = done || ret;
          EXEC_END
        });
    }
    if (handled) *handled = ret ? TRUE : FALSE;
    return r;
  }
}

SCDOM_RESULT SCAPI SciterSendEvent_api(HELEMENT he, UINT appEventCode,
                                       HELEMENT heSource, UINT_PTR reason,
                                       /*out*/ SBOOL *handled) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_5(b, appEventCode, heSource, reason, handled)

  html::helement src = element_ptr(heSource);

  html::event_behavior evt(b, src, appEventCode, reason);
  bool                 r = pview->send_behavior_event(evt);
  if (handled) *handled = r ? TRUE : FALSE;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterPostEvent_api(HELEMENT he, UINT appEventCode,
                                       HELEMENT heSource, UINT_PTR reason) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, appEventCode, heSource, reason)

  html::helement src = element_ptr(heSource);

  html::event_behavior evt(b, src, appEventCode, reason);
  pview->post_behavior_event(evt);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterCallBehaviorMethod_api(HELEMENT       he,
                                                METHOD_PARAMS *prms) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!prms) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, prms)

  r = b->call_behavior_method(*pview, (html::method_params *)prms)
          ? SCDOM_OK
          : SCDOM_OK_NOT_HANDLED;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterRequestElementData_api(HELEMENT he, LPCWSTR url,
                                                UINT     dataType,
                                                HELEMENT initiator) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!url) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, url, dataType, initiator)

  tool::handle<html::pump::request> prq =
      new html::pump::request(string(url), (html::RESOURCE_DATA_TYPE)dataType);
  prq->dst       = b;
  prq->initiator = element_ptr(initiator);

  pview->request_data(prq);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterHttpRequest_api(
    HELEMENT       he,            // element to deliver data
    LPCWSTR        url,           // url
    UINT           dataType,      // data type
    UINT           requestType,   // one of REQUEST_TYPE values
    REQUEST_PARAM *requestParams, // parameters
    UINT           nParams        // number of parameters
) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!url) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  array<html::pump::param> params;
  if (requestParams)
    for (unsigned n = 0; n < nParams; ++n) {
      html::pump::param p;
      p.name  = requestParams[n].name;
      p.value = requestParams[n].value;
      params.push(p);
    }

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_5(b, url, dataType, requestType, params)

  bool post = false;
  bool now  = false;

  switch (requestType) {
  case GET_ASYNC: break;
  case POST_ASYNC: post = true; break;
  case GET_SYNC: now = true; break;
  case POST_SYNC:
    post = true;
    now  = true;
    break;
  default: r = SCDOM_INVALID_PARAMETER; return true;
  }

  tool::handle<html::pump::request> prq =
      new html::pump::request(string(url), (html::RESOURCE_DATA_TYPE)dataType);
  prq->rq_type = post ? html::RQ_POST : html::RQ_GET;
  prq->dst     = b;
  prq->rq_params = params;

  bool res = pview->request_data(prq);

  if (now)
    r = res ? SCDOM_OK : SCDOM_OPERATION_FAILED;
  else
    r = SCDOM_OK;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetScrollInfo_api(HELEMENT he, POINT *scrollPos,
                                           RECT *viewRect, SIZE *contentSize) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!scrollPos || !viewRect || !contentSize) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_4(b, scrollPos, viewRect, contentSize)

  gool::rect view_rc = b->client_rect(*pview);
  gool::size content_sz =
      size(b->min_content_width(*pview), b->min_content_height(*pview));
  gool::point scroll_pos = b->scroll_pos();

  *viewRect    = api_cvt(view_rc);
  *scrollPos   = api_cvt(scroll_pos);
  *contentSize = api_cvt(content_sz);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSetScrollPos_api(HELEMENT he, POINT scrollPos,
                                          SBOOL smooth) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, scrollPos, smooth)

  point pos(scrollPos.x, scrollPos.y);

  pview->scroll_window(pos, b, smooth ? html::SCROLL_SMOOTH : html::SCROLL);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetElementIntrinsicWidths_api(HELEMENT he,
                                                       INT *    pMinWidth,
                                                       INT *    pMaxWidth) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  if (!pMinWidth || !pMaxWidth) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, pMinWidth, pMaxWidth)

  *pMinWidth = b->min_content_width(*pview);
  *pMaxWidth = b->max_content_width(*pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetElementIntrinsicHeight_api(HELEMENT he,
                                                       INT      forWidth,
                                                       INT *    pHeight) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  if (!pHeight) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, forWidth, pHeight)

  b->set_width(*pview, forWidth);
  *pHeight = b->min_content_height(*pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterIsElementVisible_api(HELEMENT he, SBOOL *pVisible) {
  if (!pVisible) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, pVisible)

  *pVisible = b->is_visible(*pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterIsElementEnabled_api(HELEMENT he, SBOOL *pEnabled) {
  if (!pEnabled) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, pEnabled)

  *pEnabled = !b->get_state(true).disabled();
  return SCDOM_OK;

  EXEC_END
  return r;
}

struct el_comparator {
  ELEMENT_COMPARATOR *pf;
  LPVOID              fprm;
  bool operator()(const html::helement &v1, const html::helement &v2) {
    return pf(v1, v2, fprm) < 0;
  }
};

SCDOM_RESULT SCAPI SciterSortElements_api(HELEMENT he, UINT first, UINT last,
                                          ELEMENT_COMPARATOR *cmpFunc,
                                          LPVOID              cmpFuncParam) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!cmpFunc) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_5(b, first, last, cmpFunc, cmpFuncParam)

  UINT firstIndex = first;
  UINT lastIndex  = last;

  array<helement> subs;
  child_iterator  cit(*pview, b);
  for (element *cel; cit(cel);)
    subs.push(cel);

  if (firstIndex >= subs.length()) firstIndex = UINT(subs.length());

  if (lastIndex >= subs.length()) lastIndex = UINT(subs.length());

  if (firstIndex >= lastIndex) return SCDOM_OK;

  el_comparator _comparator;
  _comparator.pf   = cmpFunc;
  _comparator.fprm = cmpFuncParam;

  tool::sort<html::helement, el_comparator>(
      subs.head() + firstIndex, lastIndex - firstIndex, _comparator);

  b->nodes.clear();
  for (unsigned n = 0; n < subs.length(); ++n) {
    html::element *t = subs[n];
    t->node_index    = n;
    b->nodes.push(t);
  }
  // pview->add_to_update(b,true);
  b->flags.indexes_are_valid = 0;
  b->reset_styles(*pview);
  b->drop_layout(pview);
  b->commit_measure(*pview);
  pview->refresh(b);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterTraverseUIEvent_api(UINT   evgroup,
                                             LPVOID eventCtlStruct,
                                             SBOOL * bOutProcessed) {
  if (!eventCtlStruct || !bOutProcessed) return SCDOM_INVALID_PARAMETER;

  switch (evgroup) {
  case ::HANDLE_MOUSE: {
    MOUSE_PARAMS * mp = (MOUSE_PARAMS *)eventCtlStruct;
    html::helement b  = element_ptr(mp->target);
    if (!b) return SCDOM_INVALID_HANDLE;

    handle<html::view> pview = b->pview();
    if (!pview) return SCDOM_PASSIVE_HANDLE;

    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START_3(b, mp, bOutProcessed)

    html::event_mouse evt;

    evt.alt_state    = mp->alt_state;
    evt.button_state = mp->button_state;
    evt.cursor       = 0;
    evt.cmd          = mp->cmd;
    evt.pos.x        = mp->pos.x;
    evt.pos.y        = mp->pos.y;
    evt.pos_view.x   = mp->pos_view.x;
    evt.pos_view.y   = mp->pos_view.y;
    evt.target       = element_handle(b);
    evt.is_on_icon   = 0;

    *bOutProcessed = pview->traverse_mouse(b, evt);

    EXEC_END
    return r;

  } break;

  case ::HANDLE_KEY: {
    KEY_PARAMS *kp = (KEY_PARAMS *)eventCtlStruct;

    html::helement b = element_ptr(kp->target);
    if (!b) return SCDOM_INVALID_HANDLE;

    handle<html::view> pview = b->pview();
    if (!pview) return SCDOM_PASSIVE_HANDLE;

    SCDOM_RESULT r = SCDOM_OK;
    EXEC_START_3(b, kp, bOutProcessed)

    html::event_key evt;

    evt.alt_state = kp->alt_state;
    evt.cmd       = kp->cmd;
    evt.key_code  = kp->key_code;
    evt.target    = element_handle(b);

    html::traverser<html::event_key> trv(*pview);
    *bOutProcessed = trv.traverse(b, evt);

    EXEC_END
    return r;
  }
  default: return SCDOM_INVALID_PARAMETER;
  }
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterSwapElements_api(HELEMENT he1, HELEMENT he2) {
  html::helement b1 = element_ptr(he1);
  if (!b1) return SCDOM_INVALID_HANDLE;
  html::helement b2 = element_ptr(he2);
  if (!b2) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b1->pview();

  if (b1 == b2) return SCDOM_INVALID_PARAMETER;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b1, b2)
  html::element::swap_locations(b1, b2, pview);
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterControlGetType_api(HELEMENT he, LPUINT pType) {
  if (!pType) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, pType)

  *pType = (UINT)b->ctl_type(*pview);

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetValue_api(HELEMENT he, VALUE *pval) {
  if (!pval) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, pval)
    //r = b->get_value(*pview, *((tool::value *)pval)) ? SCDOM_OK
    //                                                 : SCDOM_OPERATION_FAILED;
    return pview->get_element_value(b, *((tool::value *)pval), true) ? SCDOM_OK : SCDOM_OPERATION_FAILED;
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterSetValue_api(HELEMENT he, const VALUE *pval) {
  if (!pval) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;
  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;
  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, pval)
    //r = b->set_value(*pview, *((tool::value *)pval)) ? SCDOM_OK
    //                                               : SCDOM_OPERATION_FAILED;
    return pview->set_element_value(b, *((tool::value *)pval), true) ? SCDOM_OK : SCDOM_OPERATION_FAILED;
  EXEC_END
  return r;
}

// SCDOM_RESULT SCAPI SciterGetExpando( HELEMENT he, VALUE* pval, SBOOL
// forceCreation );

SCDOM_RESULT SCAPI SciterGetElementNamespace_api(HELEMENT he, void *pval) {
#if 1
  return SCDOM_OPERATION_FAILED;
#else
  if (!pval) return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::document> root = b->doc();
  if (!root) return SCDOM_PASSIVE_HANDLE;

  *pval = root->ns;
  return SCDOM_OK;
#endif
}

extern bool sciter_get_expando(html::element *b, tool::value &pval,
                               bool force_creation);

//extern bool sciter_get_object(html::element *b, tis::value &pval,
//                              bool force_creation);

SCDOM_RESULT SCAPI SciterGetExpando_api(HELEMENT he, VALUE *pval,
                                        SBOOL forceCreation) {
  if (!pval) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);

  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, pval, forceCreation)

  if (!sciter_get_expando(b, *((tool::value *)pval), forceCreation != FALSE)) {
    *(tool::value *)pval = tool::value();
    r                    = SCDOM_INVALID_HANDLE;
  }

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterGetObject_api(HELEMENT he, void *pval,
                                       SBOOL forceCreation) {
#if 1
  return SCDOM_OPERATION_FAILED;
#else 
  if (!pval) return SCDOM_INVALID_PARAMETER;

  handle<html::element> b = element_ptr(he);

  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_INVALID_HANDLE;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_3(b, pval, forceCreation)

  if (!sciter_get_object(b, *pval, forceCreation != FALSE)) {
    *pval = 0;
    r     = SCDOM_INVALID_HANDLE;
  }

  EXEC_END
  return r;
#endif
}

SCDOM_RESULT SCAPI SciterAttachHwndToElement_api(HELEMENT he, HWINDOW hwnd) {
  handle<html::element> b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = b->pview();
  if (!pview) return hwnd ? SCDOM_PASSIVE_HANDLE : SCDOM_OK;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(b, hwnd)

  handle<html::behavior::windowed> ww = b->get_behavior<html::behavior::windowed>();
  if (ww.is_defined()) {
    if (hwnd)
      ww->hwnd = hwnd;
    else
      b->detach_behavior(*pview, ww);
  } else if (hwnd) {
    ww = new html::behavior::windowed(*pview, hwnd, b);
    b->attach_behavior(*pview, ww);
  }

  EXEC_END
  return r;
}

extern bool sciter_call_scripting_function(html::element *b, const char *name,
                                           const tool::value *argv, uint argc,
                                           tool::value &retval,
                                           bool         this_method);
// extern bool sciter_call_scripting_method( html::element* b, const char* name,
// const tool::value* argv, uint argc, tool::value& retval, bool this_method );

SCDOM_RESULT SCAPI SciterCallScriptingFunction_api(HELEMENT he, LPCSTR name,
                                                   const VALUE *argv, UINT argc,
                                                   VALUE *retval) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!name) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  tool::value tr;

  if (!retval) retval = (VALUE *)&tr;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_5(b, name, argv, argc, retval)

  if (sciter_call_scripting_function(b, name, (tool::value *)argv, argc,
                                     *((tool::value *)retval), false))
    r = SCDOM_OK;
  else
    r = SCDOM_OPERATION_FAILED;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterCallScriptingMethod_api(HELEMENT he, LPCSTR name,
                                                 const VALUE *argv, UINT argc,
                                                 VALUE *retval) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!name) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  tool::value tr;

  if (!retval) retval = (VALUE *)&tr;

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_5(b, name, argv, argc, retval)

  if (sciter_call_scripting_function(b, name, (tool::value *)argv, argc,
                                     *((tool::value *)retval), true))
    r = SCDOM_OK;
  else
    r = SCDOM_OPERATION_FAILED;

  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterEvalElementScript_api(HELEMENT he, LPCWSTR script,
                                               UINT   scriptLength,
                                               VALUE *retval) {
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!script) return SCDOM_INVALID_PARAMETER;

  handle<html::document> root = b->doc();
  if (!root) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OK_NOT_HANDLED;

#if defined(SCITER)
  ustring text(script, scriptLength);
  handle<tis::xview> pview = (tis::xview *)root->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  EXEC_START_4(b, root, text, retval)

  try {
    tis::auto_scope as(pview->vm, root->ns);
    tis::value      val = tis::CsEvalString(tis::CsCurrentScope(pview->vm),
                                       tis::element_object(pview->vm, b), text,
                                       text.length());
    if (retval) *((tool::value *)retval) = tis::value_to_value(pview->vm, val);
    r = SCDOM_OK;
  } catch (tis::script_exception &) {
    tis::CsDisplay(pview->vm, pview->vm->val, pview->vm->standardError);
    r = SCDOM_OPERATION_FAILED;
  }
  EXEC_END
#elif defined(SCITERJS)
  string text = u8::cvt(wchars(script, scriptLength));
  handle<qjs::xview> pview = (qjs::xview *)root->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;
  EXEC_START_4(b, root, text, retval)
    try {
      qjs::xcontext ctx(root);
      qjs::hvalue _this = ctx.val(b);
      qjs::hvalue rv = ctx.eval_this(_this, text);
      if (retval) *((tool::value *)retval) = ctx.get<value>(rv);
      r = SCDOM_OK;
    }
    catch (qjs::exception&) {
      qjs::xcontext ctx(root);
      ctx.report_exception();
      r = SCDOM_OPERATION_FAILED;
    }
  EXEC_END

#endif
  return r;
}

SCDOM_RESULT SCAPI SciterShowPopup_api(HELEMENT hePopup, HELEMENT heAnchor,
                                       UINT placement) {
  // if(!callback)
  //  return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(hePopup);
  if (!b) return SCDOM_INVALID_HANDLE;

  html::element *anchor = element_ptr(heAnchor);
  if (!anchor) return SCDOM_INVALID_HANDLE;

  html::document *d = b->doc();
  if (!d) return SCDOM_PASSIVE_HANDLE;

  // HWINDOW root_hwnd = (HWINDOW) d->hctl;
  // html::layout_view* pview = html::layout_view::ptr(root_hwnd);
  handle<html::view> pview = d->pview();

  if (!pview) return SCDOM_INVALID_HWND;
  critical_section cs(pview->guard);

  pview->show_popup(b, anchor, html::POPUP_WINDOW, placement);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterShowPopupAt_api(HELEMENT hePopup, POINT pos,
                                         UINT placement) {
  // if(!callback)
  //  return SCDOM_INVALID_PARAMETER;
  handle<html::element> b = element_ptr(hePopup);
  if (!b) return SCDOM_INVALID_HANDLE;

  html::document *d = b->doc();
  if (!d) return SCDOM_PASSIVE_HANDLE;

  // HWINDOW root_hwnd = (HWINDOW) d->hctl;
  // html::layout_view* pview = html::layout_view::ptr(root_hwnd);
  handle<html::view> pview = d->pview();

  if (!pview) return SCDOM_INVALID_HWND;
  critical_section cs(pview->guard);

  gool::point p(pos.x, pos.y);

  pview->show_popup(b, b->doc(), html::POPUP_WINDOW, 0xFFFF0000 | placement, p);

  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterHidePopup_api(HELEMENT he) {
  html::element *self = element_ptr(he);
  if (!self) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = self->pview();

  if (!pview) return SCDOM_PASSIVE_HANDLE;

  while (self) {
    if (self->state.popup()) {
      pview->close_popup(self, false);
      return SCDOM_OK;
    }
    self = self->get_owner();
  }
  return SCDOM_OK_NOT_HANDLED;
}

SCDOM_RESULT SCAPI SciterGetElementAsset_api(HELEMENT he, UINT64 nameAtom, som_asset_t** ppass)
{
  html::helement b = element_ptr(he);
  if (!b) return SCDOM_INVALID_HANDLE;

  if (!nameAtom || !ppass) return SCDOM_INVALID_PARAMETER;

  handle<html::view> pview = b->pview();
  if (!pview) return SCDOM_PASSIVE_HANDLE;

  SCDOM_RESULT r = SCDOM_OPERATION_FAILED;

  EXEC_START_3(b, nameAtom, ppass)

    auto pass = b->get_asset(nameAtom);
    if (pass) {
      *ppass = pass;
      r = SCDOM_OK;
    } 

  EXEC_END
    return r;

}


//|
//| Node API
//|

inline html::node *node_ptr(HNODE hn) { return hn; }

inline HNODE node_handle(html::node *pn) { return pn; }

SCDOM_RESULT SCAPI SciterNodeAddRef_api(HNODE hn) {
  html::node *pn = node_ptr(hn);
  if (!pn) return SCDOM_INVALID_HANDLE;
  pn->ext_add_ref();
  return SCDOM_OK;
}
SCDOM_RESULT SCAPI SciterNodeRelease_api(HNODE hn) {
  html::node *pn = node_ptr(hn);
  if (!pn) return SCDOM_INVALID_HANDLE;
  pn->ext_release();
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeCastFromElement_api(HELEMENT he, HNODE *phn) {
  if (!he || !phn) return SCDOM_INVALID_PARAMETER;
  html::element *pe = element_ptr(he);
  *phn              = node_handle(pe);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeCastToElement_api(HNODE hn, HELEMENT *phe) {
  if (!hn || !phe) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);
  if (!pn->is_element()) return SCDOM_OK_NOT_HANDLED;
  *phe = element_handle(pn->cast<element>());
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeFirstChild_api(HNODE hn, HNODE *phn) {
  if (!hn || !phn) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  html::node *pno = pn->first_node();
  if (!pno) return SCDOM_OK_NOT_HANDLED;

  *phn = node_handle(pno);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeLastChild_api(HNODE hn, HNODE *phn) {
  if (!hn || !phn) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  html::node *pno = pn->last_node();
  if (!pno) return SCDOM_OK_NOT_HANDLED;

  *phn = node_handle(pno);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeNextSibling_api(HNODE hn, HNODE *phn) {
  if (!hn || !phn) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  html::node *pno = pn->next_node();
  if (!pno) return SCDOM_OK_NOT_HANDLED;

  *phn = node_handle(pno);
  return SCDOM_OK;
}
SCDOM_RESULT SCAPI SciterNodePrevSibling_api(HNODE hn, HNODE *phn) {
  if (!hn || !phn) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  html::node *pno = pn->prev_node();
  if (!pno) return SCDOM_OK_NOT_HANDLED;

  *phn = node_handle(pno);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeParent_api(HNODE hn, HELEMENT *phe) {
  if (!hn || !phe) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  html::element *peo = pn->dom_parent();
  if (!peo) return SCDOM_OK_NOT_HANDLED;

  *phe = element_handle(peo);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeNthChild_api(HNODE hn, UINT n, HNODE *phn) {
  if (!hn || !phn) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  if (!pn->is_element()) return SCDOM_OK_NOT_HANDLED;

  html::element *el = pn->cast<html::element>();
  if (n >= el->nodes.length()) return SCDOM_INVALID_PARAMETER;

  *phn = node_handle(el->nodes[n]);
  return SCDOM_OK;
}
SCDOM_RESULT SCAPI SciterNodeChildrenCount_api(HNODE hn, UINT *pnum) {
  if (!hn || !pnum) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);

  if (!pn->is_element()) {
    *pnum = 0;
    return SCDOM_OK;
  }

  html::element *el = pn->cast<html::element>();
  *pnum             = UINT(el->nodes.length());
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeType_api(HNODE hn, UINT *pnt /*NODE_TYPE*/) {
  if (!hn || !pnt) return SCDOM_INVALID_PARAMETER;
  html::node *pn = node_ptr(hn);
  if (pn->is_element())
    *pnt = NT_ELEMENT;
  else if (pn->is_comment())
    *pnt = NT_COMMENT;
  else if (pn->is_text())
    *pnt = NT_TEXT;
  else
    return SCDOM_OK_NOT_HANDLED;
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeGetText_api(HNODE hn, LPCWSTR_RECEIVER *rcv,
                                         LPVOID rcv_param) {
  if (!hn || !rcv) return SCDOM_INVALID_PARAMETER;
  html::node * pn = node_ptr(hn);
  tool::wchars txt;
  if (pn->is_comment())
    txt = pn->cast<comment>()->chars();
  else if (pn->is_text())
    txt = pn->cast<text>()->chars();
  else
    return SCDOM_OK_NOT_HANDLED;
  rcv(txt.start, UINT(txt.length), rcv_param);
  return SCDOM_OK;
}

SCDOM_RESULT SCAPI SciterNodeSetText_api(HNODE hn, LPCWSTR text,
                                         UINT textLength) {
  if (!hn) return SCDOM_INVALID_PARAMETER;
  handle<html::node> pn = node_ptr(hn);
  tool::wchars       txt(text, textLength);

  handle<html::view> pview = pn->parent ? pn->parent->pview() : nullptr;

  if (!pview) {
    if (pn->is_comment())
      pn->cast<html::comment>()->chars = txt;
    else if (pn->is_text())
      pn->cast<html::text>()->chars = txt;
    else
      return SCDOM_OK_NOT_HANDLED;
    return SCDOM_OK;
  }

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(pn, txt)

  if (pn->is_comment())
    pn->cast<html::comment>()->chars = txt;
  else if (pn->is_text())
    pn->cast<html::text>()->chars = txt;
  else {
    r = SCDOM_OK_NOT_HANDLED;
    return true;
  }
  pview->add_to_update(pn->parent, html::CHANGES_MODEL);

  EXEC_END
  return r;
}

/*enum NODE_INS_TARGET
{
  NIT_BEFORE,
  NIT_AFTER,
  NIT_APPEND,
  NIT_PREPEND,
};*/

SCDOM_RESULT SCAPI SciterNodeInsert_api(HNODE hn,
                                        UINT  where /*NODE_INS_TARGET*/,
                                        HNODE what) {
  if (!hn || !what) return SCDOM_INVALID_PARAMETER;
  html::node *pn    = node_ptr(hn);
  html::node *pnsrc = node_ptr(what);
  if (pnsrc->parent) return SCDOM_INVALID_HANDLE;

  handle<html::view> pview = pn->parent ? pn->parent->pview() : 0;

  auto do_it = [&]() -> SCDOM_RESULT {
    switch (where) {
    case NIT_BEFORE:
      if (!pn->parent) return SCDOM_PASSIVE_HANDLE;
      pn->parent->insert(pn->node_index, pnsrc, pview);
      break;
    case NIT_AFTER:
      if (!pn->parent) return SCDOM_PASSIVE_HANDLE;
      pn->parent->insert(pn->node_index + 1, pnsrc, pview);
      break;
    case NIT_APPEND:
      if (!pn->is_element()) return SCDOM_INVALID_PARAMETER;
      pn->cast<element>()->append(pnsrc, pview);
      break;
    case NIT_PREPEND:
      if (!pn->is_element()) return SCDOM_INVALID_PARAMETER;
      pn->cast<element>()->insert(0, pnsrc, pview);
      break;
    }
    return SCDOM_OK;
  };

  if (!pview) return do_it();

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START(do_it)
  r = do_it();
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterNodeRemove_api(HNODE hn, SBOOL finalize) {
  if (!hn) return SCDOM_INVALID_PARAMETER;
  handle<html::node> pn = node_ptr(hn);

  handle<html::view> pview = pn->pview();

  if (!pview) {
    pn->remove(finalize != FALSE);
    return SCDOM_OK;
  }

  SCDOM_RESULT r = SCDOM_OK;
  EXEC_START_2(pn, finalize)
  pn->remove(finalize != FALSE);
  EXEC_END
  return r;
}

SCDOM_RESULT SCAPI SciterCreateTextNode_api(LPCWSTR text, UINT textLength,
                                            HNODE *phn) {
  if (!text || !textLength || !phn) return SCDOM_INVALID_PARAMETER;

  html::hnode pn = new html::text(wchars(text, textLength));
  if (pn) {
    pn->ext_add_ref();
    *phn = node_handle(pn);
    return SCDOM_OK;
  }
  return SCDOM_OPERATION_FAILED;
}

SCDOM_RESULT SCAPI SciterCreateCommentNode_api(LPCWSTR text, UINT textLength,
                                               HNODE *phn) {
  if (!text || !textLength || !phn) return SCDOM_INVALID_PARAMETER;

  html::hnode pn = new html::comment(wchars(text, textLength));
  if (pn) {
    pn->ext_add_ref();
    *phn = node_handle(pn);
    return SCDOM_OK;
  }
  return SCDOM_OPERATION_FAILED;
}

#undef EXEC_START
#undef EXEC_START_2
#undef EXEC_START_3
#undef EXEC_START_4
#undef EXEC_START_5
#undef EXEC_END

UINT_PTR SCAPI SciterPostCallback_api(HWINDOW hwnd, UINT_PTR wparam, UINT_PTR lparam, UINT timeoutms)
{
  get_pview(hwnd);
  if (!pview)
    return 0;
  
  if (pview->callback) {
    pview->async([=]() -> bool {
      pview->callback->post_notify(pview, wparam, lparam);
      return true;
    });
  }
  return SCDOM_OK;
}

