# Alternative GNU Make project makefile autogenerated by Premake

ifndef config
  config=debug_x32
endif

ifndef verbose
  SILENT = @
endif

.PHONY: clean prebuild

SHELLTYPE := posix
ifeq (.exe,$(findstring .exe,$(ComSpec)))
	SHELLTYPE := msdos
endif

# Configurations
# #############################################

RESCOMP = windres
TARGETDIR = ../../sdk/bin.lnx
TARGET = $(TARGETDIR)/tiscript
INCLUDES += -I../.. -I../../engine -I../../engine/tool -I../../engine/gool -I../../engine/html -I../../build.windows/include -I../../engine/tiscript -I../../engine/external/uv/include -I../../engine/external/uv/src -I../../engine/external/uv-tls/include -I../../engine/tiscript/include -I../../engine/tiscript/dybase/inc -I../../engine/external/zlib
FORCE_INCLUDE +=
ALL_CPPFLAGS += $(CPPFLAGS) -MMD -MP $(DEFINES) $(INCLUDES)
ALL_RESFLAGS += $(RESFLAGS) $(DEFINES) $(INCLUDES)
LIBS += -luuid
LDDEPS +=
LINKCMD = $(CXX) -o "$@" $(OBJECTS) $(RESOURCES) $(ALL_LDFLAGS) $(LIBS)
define PREBUILDCMDS
endef
define PRELINKCMDS
endef
define POSTBUILDCMDS
endef

ifeq ($(config),debug_x32)
OBJDIR = obj/x32/Debug/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),debug_x64)
OBJDIR = obj/x64/Debug/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),debug_arm32)
OBJDIR = obj/arm32/Debug/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),debug_arm64)
OBJDIR = obj/arm64/Debug/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DDEBUG -D_DEBUG -DDUMP_LEAKS -D_GNU_SOURCE -DSCITER_BUILD -DSK_DEBUG
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -g `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -g -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),release_x32)
OBJDIR = obj/x32/Release/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m32 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib32 -m32 -flto -s -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),release_x64)
OBJDIR = obj/x64/Release/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -m64 -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -L/usr/lib64 -m64 -flto -s -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),release_arm32)
OBJDIR = obj/arm32/Release/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else ifeq ($(config),release_arm64)
OBJDIR = obj/arm64/Release/tiscript
DEFINES += -DDEVICE=DESKTOP -DUSE_LOTTIE=1 -DMONOLITHIC -DNDEBUG -D_GNU_SOURCE -DSCITER_BUILD -DSK_RELEASE
ALL_CFLAGS += $(CFLAGS) $(ALL_CPPFLAGS) -flto -Os `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_CXXFLAGS += $(CXXFLAGS) $(ALL_CPPFLAGS) -flto -Os -std=c++17 `pkg-config gtk+-3.0 --cflags` `pkg-config fontconfig --cflags` -fPIC -Wno-unknown-pragmas -Wno-write-strings -Wno-deprecated-declarations -ldl -latomic
ALL_LDFLAGS += $(LDFLAGS) -flto -s -static-libstdc++ -latomic `pkg-config --libs glib-2.0` -fPIC -pthread -Wl,--no-undefined -ldl

else
  $(error "invalid configuration $(config)")
endif

# Per File Configurations
# #############################################


# File sets
# #############################################

OBJECTS :=

OBJECTS += $(OBJDIR)/adler32.o
OBJECTS += $(OBJDIR)/aes.o
OBJECTS += $(OBJDIR)/aesni.o
OBJECTS += $(OBJDIR)/affentry.o
OBJECTS += $(OBJDIR)/affixmgr.o
OBJECTS += $(OBJDIR)/arc4.o
OBJECTS += $(OBJDIR)/asn1parse.o
OBJECTS += $(OBJDIR)/asn1write.o
OBJECTS += $(OBJDIR)/async.o
OBJECTS += $(OBJDIR)/base64.o
OBJECTS += $(OBJDIR)/bignum.o
OBJECTS += $(OBJDIR)/bio.o
OBJECTS += $(OBJDIR)/blowfish.o
OBJECTS += $(OBJDIR)/btree.o
OBJECTS += $(OBJDIR)/camellia.o
OBJECTS += $(OBJDIR)/ccm.o
OBJECTS += $(OBJDIR)/certs.o
OBJECTS += $(OBJDIR)/cipher.o
OBJECTS += $(OBJDIR)/cipher_wrap.o
OBJECTS += $(OBJDIR)/cmac.o
OBJECTS += $(OBJDIR)/compress.o
OBJECTS += $(OBJDIR)/core.o
OBJECTS += $(OBJDIR)/crc32.o
OBJECTS += $(OBJDIR)/cs_angle.o
OBJECTS += $(OBJDIR)/cs_api.o
OBJECTS += $(OBJDIR)/cs_asset.o
OBJECTS += $(OBJDIR)/cs_bytevector.o
OBJECTS += $(OBJDIR)/cs_cobject.o
OBJECTS += $(OBJDIR)/cs_color.o
OBJECTS += $(OBJDIR)/cs_com.o
OBJECTS += $(OBJDIR)/cs_datetime.o
OBJECTS += $(OBJDIR)/cs_debug.o
OBJECTS += $(OBJDIR)/cs_duration.o
OBJECTS += $(OBJDIR)/cs_enter.o
OBJECTS += $(OBJDIR)/cs_env.o
OBJECTS += $(OBJDIR)/cs_error.o
OBJECTS += $(OBJDIR)/cs_eval.o
OBJECTS += $(OBJDIR)/cs_fcn.o
OBJECTS += $(OBJDIR)/cs_file.o
OBJECTS += $(OBJDIR)/cs_float.o
OBJECTS += $(OBJDIR)/cs_hash.o
OBJECTS += $(OBJDIR)/cs_heap.o
OBJECTS += $(OBJDIR)/cs_instanceof.o
OBJECTS += $(OBJDIR)/cs_int.o
OBJECTS += $(OBJDIR)/cs_integer.o
OBJECTS += $(OBJDIR)/cs_json.o
OBJECTS += $(OBJDIR)/cs_length.o
OBJECTS += $(OBJDIR)/cs_math.o
OBJECTS += $(OBJDIR)/cs_method.o
OBJECTS += $(OBJDIR)/cs_net.o
OBJECTS += $(OBJDIR)/cs_object.o
OBJECTS += $(OBJDIR)/cs_parse.o
OBJECTS += $(OBJDIR)/cs_persistent.o
OBJECTS += $(OBJDIR)/cs_printf.o
OBJECTS += $(OBJDIR)/cs_rcode.o
OBJECTS += $(OBJDIR)/cs_regexp.o
OBJECTS += $(OBJDIR)/cs_scn.o
OBJECTS += $(OBJDIR)/cs_storage.o
OBJECTS += $(OBJDIR)/cs_stream.o
OBJECTS += $(OBJDIR)/cs_string.o
OBJECTS += $(OBJDIR)/cs_symbol.o
OBJECTS += $(OBJDIR)/cs_system.o
OBJECTS += $(OBJDIR)/cs_type.o
OBJECTS += $(OBJDIR)/cs_vector.o
OBJECTS += $(OBJDIR)/cs_vm.o
OBJECTS += $(OBJDIR)/cs_wcode.o
OBJECTS += $(OBJDIR)/cs_xml_parser.o
OBJECTS += $(OBJDIR)/csutil.o
OBJECTS += $(OBJDIR)/ctr_drbg.o
OBJECTS += $(OBJDIR)/database.o
OBJECTS += $(OBJDIR)/debug.o
OBJECTS += $(OBJDIR)/deflate.o
OBJECTS += $(OBJDIR)/des.o
OBJECTS += $(OBJDIR)/dhm.o
OBJECTS += $(OBJDIR)/dl.o
OBJECTS += $(OBJDIR)/dybase.o
OBJECTS += $(OBJDIR)/ecdh.o
OBJECTS += $(OBJDIR)/ecdsa.o
OBJECTS += $(OBJDIR)/ecjpake.o
OBJECTS += $(OBJDIR)/ecp.o
OBJECTS += $(OBJDIR)/ecp_curves.o
OBJECTS += $(OBJDIR)/entropy.o
OBJECTS += $(OBJDIR)/entropy_poll.o
OBJECTS += $(OBJDIR)/error.o
OBJECTS += $(OBJDIR)/file.o
OBJECTS += $(OBJDIR)/filemgr.o
OBJECTS += $(OBJDIR)/fs-poll.o
OBJECTS += $(OBJDIR)/fs.o
OBJECTS += $(OBJDIR)/gcm.o
OBJECTS += $(OBJDIR)/getaddrinfo.o
OBJECTS += $(OBJDIR)/getnameinfo.o
OBJECTS += $(OBJDIR)/hashmgr.o
OBJECTS += $(OBJDIR)/havege.o
OBJECTS += $(OBJDIR)/hmac_drbg.o
OBJECTS += $(OBJDIR)/hunspell.o
OBJECTS += $(OBJDIR)/hunzip.o
OBJECTS += $(OBJDIR)/idna.o
OBJECTS += $(OBJDIR)/inet.o
OBJECTS += $(OBJDIR)/inffast.o
OBJECTS += $(OBJDIR)/inflate.o
OBJECTS += $(OBJDIR)/inftrees.o
OBJECTS += $(OBJDIR)/ioapi.o
OBJECTS += $(OBJDIR)/linux-core.o
OBJECTS += $(OBJDIR)/linux-inotify.o
OBJECTS += $(OBJDIR)/linux-syscalls.o
OBJECTS += $(OBJDIR)/linux_specifics.o
OBJECTS += $(OBJDIR)/linux_spell_checker.o
OBJECTS += $(OBJDIR)/loop-watcher.o
OBJECTS += $(OBJDIR)/loop.o
OBJECTS += $(OBJDIR)/md.o
OBJECTS += $(OBJDIR)/md2.o
OBJECTS += $(OBJDIR)/md4.o
OBJECTS += $(OBJDIR)/md5.o
OBJECTS += $(OBJDIR)/md_wrap.o
OBJECTS += $(OBJDIR)/memory_buffer_alloc.o
OBJECTS += $(OBJDIR)/net_sockets.o
OBJECTS += $(OBJDIR)/oid.o
OBJECTS += $(OBJDIR)/padlock.o
OBJECTS += $(OBJDIR)/pagepool.o
OBJECTS += $(OBJDIR)/pem.o
OBJECTS += $(OBJDIR)/phonet.o
OBJECTS += $(OBJDIR)/pipe.o
OBJECTS += $(OBJDIR)/pk.o
OBJECTS += $(OBJDIR)/pk_wrap.o
OBJECTS += $(OBJDIR)/pkcs11.o
OBJECTS += $(OBJDIR)/pkcs12.o
OBJECTS += $(OBJDIR)/pkcs5.o
OBJECTS += $(OBJDIR)/pkparse.o
OBJECTS += $(OBJDIR)/pkwrite.o
OBJECTS += $(OBJDIR)/platform.o
OBJECTS += $(OBJDIR)/poll.o
OBJECTS += $(OBJDIR)/process.o
OBJECTS += $(OBJDIR)/procfs-exepath.o
OBJECTS += $(OBJDIR)/proctitle.o
OBJECTS += $(OBJDIR)/random-devurandom.o
OBJECTS += $(OBJDIR)/random-getrandom.o
OBJECTS += $(OBJDIR)/random-sysctl-linux.o
OBJECTS += $(OBJDIR)/random.o
OBJECTS += $(OBJDIR)/re.o
OBJECTS += $(OBJDIR)/replist.o
OBJECTS += $(OBJDIR)/ripemd160.o
OBJECTS += $(OBJDIR)/rsa.o
OBJECTS += $(OBJDIR)/rsa_internal.o
OBJECTS += $(OBJDIR)/sha1.o
OBJECTS += $(OBJDIR)/sha256.o
OBJECTS += $(OBJDIR)/sha512.o
OBJECTS += $(OBJDIR)/signal.o
OBJECTS += $(OBJDIR)/snprintf.o
OBJECTS += $(OBJDIR)/snscanf.o
OBJECTS += $(OBJDIR)/ssl_cache.o
OBJECTS += $(OBJDIR)/ssl_ciphersuites.o
OBJECTS += $(OBJDIR)/ssl_cli.o
OBJECTS += $(OBJDIR)/ssl_cookie.o
OBJECTS += $(OBJDIR)/ssl_srv.o
OBJECTS += $(OBJDIR)/ssl_ticket.o
OBJECTS += $(OBJDIR)/ssl_tls.o
OBJECTS += $(OBJDIR)/stream.o
OBJECTS += $(OBJDIR)/strscpy.o
OBJECTS += $(OBJDIR)/suggestmgr.o
OBJECTS += $(OBJDIR)/tcp.o
OBJECTS += $(OBJDIR)/terrascript.o
OBJECTS += $(OBJDIR)/thread.o
OBJECTS += $(OBJDIR)/threading.o
OBJECTS += $(OBJDIR)/threadpool.o
OBJECTS += $(OBJDIR)/timer.o
OBJECTS += $(OBJDIR)/timing.o
OBJECTS += $(OBJDIR)/tl_async_io.o
OBJECTS += $(OBJDIR)/tl_base64.o
OBJECTS += $(OBJDIR)/tl_basic.o
OBJECTS += $(OBJDIR)/tl_crc32.o
OBJECTS += $(OBJDIR)/tl_datetime.o
OBJECTS += $(OBJDIR)/tl_eval_parser.o
OBJECTS += $(OBJDIR)/tl_eval_vm.o
OBJECTS += $(OBJDIR)/tl_filesystem.o
OBJECTS += $(OBJDIR)/tl_lzf.o
OBJECTS += $(OBJDIR)/tl_mm_file.o
OBJECTS += $(OBJDIR)/tl_sar.o
OBJECTS += $(OBJDIR)/tl_string.o
OBJECTS += $(OBJDIR)/tl_tokenizer.o
OBJECTS += $(OBJDIR)/tl_url.o
OBJECTS += $(OBJDIR)/tl_ustring.o
OBJECTS += $(OBJDIR)/tl_util.o
OBJECTS += $(OBJDIR)/tl_wregexp.o
OBJECTS += $(OBJDIR)/tl_zip.o
OBJECTS += $(OBJDIR)/tls_engine.o
OBJECTS += $(OBJDIR)/trees.o
OBJECTS += $(OBJDIR)/tty.o
OBJECTS += $(OBJDIR)/ucdata_lt.o
OBJECTS += $(OBJDIR)/udp.o
OBJECTS += $(OBJDIR)/uncompr.o
OBJECTS += $(OBJDIR)/unzip.o
OBJECTS += $(OBJDIR)/uv-common.o
OBJECTS += $(OBJDIR)/uv-data-getter-setters.o
OBJECTS += $(OBJDIR)/uv_tls.o
OBJECTS += $(OBJDIR)/version.o
OBJECTS += $(OBJDIR)/version1.o
OBJECTS += $(OBJDIR)/version_features.o
OBJECTS += $(OBJDIR)/websockets.o
OBJECTS += $(OBJDIR)/x509.o
OBJECTS += $(OBJDIR)/x509_create.o
OBJECTS += $(OBJDIR)/x509_crl.o
OBJECTS += $(OBJDIR)/x509_crt.o
OBJECTS += $(OBJDIR)/x509_csr.o
OBJECTS += $(OBJDIR)/x509write_crt.o
OBJECTS += $(OBJDIR)/x509write_csr.o
OBJECTS += $(OBJDIR)/xtea.o
OBJECTS += $(OBJDIR)/zutil.o

# Rules
# #############################################

all: $(TARGET)
	@:

$(TARGET): $(OBJECTS) $(LDDEPS) | $(TARGETDIR)
	$(PRELINKCMDS)
	@echo Linking tiscript
	$(SILENT) $(LINKCMD)
	$(POSTBUILDCMDS)

$(TARGETDIR):
	@echo Creating $(TARGETDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(TARGETDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(TARGETDIR))
endif

$(OBJDIR):
	@echo Creating $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(OBJDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(OBJDIR))
endif

clean:
	@echo Cleaning tiscript
ifeq (posix,$(SHELLTYPE))
	$(SILENT) rm -f  $(TARGET)
	$(SILENT) rm -rf $(OBJDIR)
else
	$(SILENT) if exist $(subst /,\\,$(TARGET)) del $(subst /,\\,$(TARGET))
	$(SILENT) if exist $(subst /,\\,$(OBJDIR)) rmdir /s /q $(subst /,\\,$(OBJDIR))
endif

prebuild: | $(OBJDIR)
	$(PREBUILDCMDS)

ifneq (,$(PCH))
$(OBJECTS): $(GCH) | $(PCH_PLACEHOLDER)
$(GCH): $(PCH) | prebuild
	@echo $(notdir $<)
	$(SILENT) $(CXX) -x c++-header $(ALL_CXXFLAGS) -o "$@" -MF "$(@:%.gch=%.d)" -c "$<"
$(PCH_PLACEHOLDER): $(GCH) | $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) touch "$@"
else
	$(SILENT) echo $null >> "$@"
endif
else
$(OBJECTS): | prebuild
endif


# File Rules
# #############################################

$(OBJDIR)/affentry.o: ../../engine/external/hunspell/affentry.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/affixmgr.o: ../../engine/external/hunspell/affixmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/csutil.o: ../../engine/external/hunspell/csutil.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/filemgr.o: ../../engine/external/hunspell/filemgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hashmgr.o: ../../engine/external/hunspell/hashmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hunspell.o: ../../engine/external/hunspell/hunspell.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hunzip.o: ../../engine/external/hunspell/hunzip.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/phonet.o: ../../engine/external/hunspell/phonet.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/replist.o: ../../engine/external/hunspell/replist.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/suggestmgr.o: ../../engine/external/hunspell/suggestmgr.cxx
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bio.o: ../../engine/external/uv-tls/src/bio.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/aes.o: ../../engine/external/uv-tls/src/mbedtls/aes.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/aesni.o: ../../engine/external/uv-tls/src/mbedtls/aesni.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/arc4.o: ../../engine/external/uv-tls/src/mbedtls/arc4.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/asn1parse.o: ../../engine/external/uv-tls/src/mbedtls/asn1parse.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/asn1write.o: ../../engine/external/uv-tls/src/mbedtls/asn1write.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/base64.o: ../../engine/external/uv-tls/src/mbedtls/base64.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/bignum.o: ../../engine/external/uv-tls/src/mbedtls/bignum.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/blowfish.o: ../../engine/external/uv-tls/src/mbedtls/blowfish.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/camellia.o: ../../engine/external/uv-tls/src/mbedtls/camellia.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ccm.o: ../../engine/external/uv-tls/src/mbedtls/ccm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/certs.o: ../../engine/external/uv-tls/src/mbedtls/certs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cipher.o: ../../engine/external/uv-tls/src/mbedtls/cipher.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cipher_wrap.o: ../../engine/external/uv-tls/src/mbedtls/cipher_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cmac.o: ../../engine/external/uv-tls/src/mbedtls/cmac.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ctr_drbg.o: ../../engine/external/uv-tls/src/mbedtls/ctr_drbg.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/debug.o: ../../engine/external/uv-tls/src/mbedtls/debug.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/des.o: ../../engine/external/uv-tls/src/mbedtls/des.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dhm.o: ../../engine/external/uv-tls/src/mbedtls/dhm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecdh.o: ../../engine/external/uv-tls/src/mbedtls/ecdh.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecdsa.o: ../../engine/external/uv-tls/src/mbedtls/ecdsa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecjpake.o: ../../engine/external/uv-tls/src/mbedtls/ecjpake.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecp.o: ../../engine/external/uv-tls/src/mbedtls/ecp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ecp_curves.o: ../../engine/external/uv-tls/src/mbedtls/ecp_curves.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/entropy.o: ../../engine/external/uv-tls/src/mbedtls/entropy.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/entropy_poll.o: ../../engine/external/uv-tls/src/mbedtls/entropy_poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/error.o: ../../engine/external/uv-tls/src/mbedtls/error.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/gcm.o: ../../engine/external/uv-tls/src/mbedtls/gcm.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/havege.o: ../../engine/external/uv-tls/src/mbedtls/havege.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/hmac_drbg.o: ../../engine/external/uv-tls/src/mbedtls/hmac_drbg.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md.o: ../../engine/external/uv-tls/src/mbedtls/md.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md2.o: ../../engine/external/uv-tls/src/mbedtls/md2.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md4.o: ../../engine/external/uv-tls/src/mbedtls/md4.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md5.o: ../../engine/external/uv-tls/src/mbedtls/md5.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/md_wrap.o: ../../engine/external/uv-tls/src/mbedtls/md_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/memory_buffer_alloc.o: ../../engine/external/uv-tls/src/mbedtls/memory_buffer_alloc.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/net_sockets.o: ../../engine/external/uv-tls/src/mbedtls/net_sockets.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/oid.o: ../../engine/external/uv-tls/src/mbedtls/oid.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/padlock.o: ../../engine/external/uv-tls/src/mbedtls/padlock.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pem.o: ../../engine/external/uv-tls/src/mbedtls/pem.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pk.o: ../../engine/external/uv-tls/src/mbedtls/pk.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pk_wrap.o: ../../engine/external/uv-tls/src/mbedtls/pk_wrap.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs11.o: ../../engine/external/uv-tls/src/mbedtls/pkcs11.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs12.o: ../../engine/external/uv-tls/src/mbedtls/pkcs12.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkcs5.o: ../../engine/external/uv-tls/src/mbedtls/pkcs5.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkparse.o: ../../engine/external/uv-tls/src/mbedtls/pkparse.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pkwrite.o: ../../engine/external/uv-tls/src/mbedtls/pkwrite.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/platform.o: ../../engine/external/uv-tls/src/mbedtls/platform.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ripemd160.o: ../../engine/external/uv-tls/src/mbedtls/ripemd160.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rsa.o: ../../engine/external/uv-tls/src/mbedtls/rsa.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/rsa_internal.o: ../../engine/external/uv-tls/src/mbedtls/rsa_internal.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha1.o: ../../engine/external/uv-tls/src/mbedtls/sha1.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha256.o: ../../engine/external/uv-tls/src/mbedtls/sha256.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/sha512.o: ../../engine/external/uv-tls/src/mbedtls/sha512.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cache.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cache.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_ciphersuites.o: ../../engine/external/uv-tls/src/mbedtls/ssl_ciphersuites.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cli.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cli.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_cookie.o: ../../engine/external/uv-tls/src/mbedtls/ssl_cookie.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_srv.o: ../../engine/external/uv-tls/src/mbedtls/ssl_srv.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_ticket.o: ../../engine/external/uv-tls/src/mbedtls/ssl_ticket.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ssl_tls.o: ../../engine/external/uv-tls/src/mbedtls/ssl_tls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/threading.o: ../../engine/external/uv-tls/src/mbedtls/threading.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/timing.o: ../../engine/external/uv-tls/src/mbedtls/timing.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version.o: ../../engine/external/uv-tls/src/mbedtls/version.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version_features.o: ../../engine/external/uv-tls/src/mbedtls/version_features.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509.o: ../../engine/external/uv-tls/src/mbedtls/x509.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_create.o: ../../engine/external/uv-tls/src/mbedtls/x509_create.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_crl.o: ../../engine/external/uv-tls/src/mbedtls/x509_crl.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_crt.o: ../../engine/external/uv-tls/src/mbedtls/x509_crt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509_csr.o: ../../engine/external/uv-tls/src/mbedtls/x509_csr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509write_crt.o: ../../engine/external/uv-tls/src/mbedtls/x509write_crt.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/x509write_csr.o: ../../engine/external/uv-tls/src/mbedtls/x509write_csr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/xtea.o: ../../engine/external/uv-tls/src/mbedtls/xtea.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tls_engine.o: ../../engine/external/uv-tls/src/tls_engine.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv_tls.o: ../../engine/external/uv-tls/src/uv_tls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/fs-poll.o: ../../engine/external/uv/src/fs-poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/idna.o: ../../engine/external/uv/src/idna.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inet.o: ../../engine/external/uv/src/inet.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random.o: ../../engine/external/uv/src/random.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/strscpy.o: ../../engine/external/uv/src/strscpy.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/threadpool.o: ../../engine/external/uv/src/threadpool.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/timer.o: ../../engine/external/uv/src/timer.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/async.o: ../../engine/external/uv/src/unix/async.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/core.o: ../../engine/external/uv/src/unix/core.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dl.o: ../../engine/external/uv/src/unix/dl.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/fs.o: ../../engine/external/uv/src/unix/fs.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/getaddrinfo.o: ../../engine/external/uv/src/unix/getaddrinfo.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/getnameinfo.o: ../../engine/external/uv/src/unix/getnameinfo.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-core.o: ../../engine/external/uv/src/unix/linux-core.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-inotify.o: ../../engine/external/uv/src/unix/linux-inotify.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux-syscalls.o: ../../engine/external/uv/src/unix/linux-syscalls.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/loop-watcher.o: ../../engine/external/uv/src/unix/loop-watcher.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/loop.o: ../../engine/external/uv/src/unix/loop.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pipe.o: ../../engine/external/uv/src/unix/pipe.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/poll.o: ../../engine/external/uv/src/unix/poll.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/process.o: ../../engine/external/uv/src/unix/process.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/procfs-exepath.o: ../../engine/external/uv/src/unix/procfs-exepath.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/proctitle.o: ../../engine/external/uv/src/unix/proctitle.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-devurandom.o: ../../engine/external/uv/src/unix/random-devurandom.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-getrandom.o: ../../engine/external/uv/src/unix/random-getrandom.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/random-sysctl-linux.o: ../../engine/external/uv/src/unix/random-sysctl-linux.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/signal.o: ../../engine/external/uv/src/unix/signal.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/stream.o: ../../engine/external/uv/src/unix/stream.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tcp.o: ../../engine/external/uv/src/unix/tcp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/thread.o: ../../engine/external/uv/src/unix/thread.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tty.o: ../../engine/external/uv/src/unix/tty.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/udp.o: ../../engine/external/uv/src/unix/udp.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv-common.o: ../../engine/external/uv/src/uv-common.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uv-data-getter-setters.o: ../../engine/external/uv/src/uv-data-getter-setters.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/version1.o: ../../engine/external/uv/src/version.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/adler32.o: ../../engine/external/zlib/adler32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/compress.o: ../../engine/external/zlib/compress.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/crc32.o: ../../engine/external/zlib/crc32.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/deflate.o: ../../engine/external/zlib/deflate.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inffast.o: ../../engine/external/zlib/inffast.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inflate.o: ../../engine/external/zlib/inflate.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/inftrees.o: ../../engine/external/zlib/inftrees.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ioapi.o: ../../engine/external/zlib/ioapi.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/trees.o: ../../engine/external/zlib/trees.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/uncompr.o: ../../engine/external/zlib/uncompr.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/unzip.o: ../../engine/external/zlib/unzip.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/zutil.o: ../../engine/external/zlib/zutil.c
	@echo $(notdir $<)
	$(SILENT) $(CC) $(ALL_CFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_com.o: ../../engine/tiscript/com/cs_com.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_eval.o: ../../engine/tiscript/com/cs_eval.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_scn.o: ../../engine/tiscript/com/cs_scn.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_wcode.o: ../../engine/tiscript/com/cs_wcode.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/btree.o: ../../engine/tiscript/dybase/src/btree.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/database.o: ../../engine/tiscript/dybase/src/database.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/dybase.o: ../../engine/tiscript/dybase/src/dybase.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/file.o: ../../engine/tiscript/dybase/src/file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/pagepool.o: ../../engine/tiscript/dybase/src/pagepool.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_angle.o: ../../engine/tiscript/int/cs_angle.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_api.o: ../../engine/tiscript/int/cs_api.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_asset.o: ../../engine/tiscript/int/cs_asset.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_bytevector.o: ../../engine/tiscript/int/cs_bytevector.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_cobject.o: ../../engine/tiscript/int/cs_cobject.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_color.o: ../../engine/tiscript/int/cs_color.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_datetime.o: ../../engine/tiscript/int/cs_datetime.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_debug.o: ../../engine/tiscript/int/cs_debug.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_duration.o: ../../engine/tiscript/int/cs_duration.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_enter.o: ../../engine/tiscript/int/cs_enter.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_env.o: ../../engine/tiscript/int/cs_env.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_error.o: ../../engine/tiscript/int/cs_error.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_fcn.o: ../../engine/tiscript/int/cs_fcn.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_file.o: ../../engine/tiscript/int/cs_file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_float.o: ../../engine/tiscript/int/cs_float.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_hash.o: ../../engine/tiscript/int/cs_hash.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_heap.o: ../../engine/tiscript/int/cs_heap.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_instanceof.o: ../../engine/tiscript/int/cs_instanceof.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_int.o: ../../engine/tiscript/int/cs_int.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_integer.o: ../../engine/tiscript/int/cs_integer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_json.o: ../../engine/tiscript/int/cs_json.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_length.o: ../../engine/tiscript/int/cs_length.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_math.o: ../../engine/tiscript/int/cs_math.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_method.o: ../../engine/tiscript/int/cs_method.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_net.o: ../../engine/tiscript/int/cs_net.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_object.o: ../../engine/tiscript/int/cs_object.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_parse.o: ../../engine/tiscript/int/cs_parse.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_persistent.o: ../../engine/tiscript/int/cs_persistent.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_printf.o: ../../engine/tiscript/int/cs_printf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_rcode.o: ../../engine/tiscript/int/cs_rcode.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_regexp.o: ../../engine/tiscript/int/cs_regexp.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_storage.o: ../../engine/tiscript/int/cs_storage.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_stream.o: ../../engine/tiscript/int/cs_stream.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_string.o: ../../engine/tiscript/int/cs_string.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_symbol.o: ../../engine/tiscript/int/cs_symbol.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_system.o: ../../engine/tiscript/int/cs_system.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_type.o: ../../engine/tiscript/int/cs_type.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_vector.o: ../../engine/tiscript/int/cs_vector.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_vm.o: ../../engine/tiscript/int/cs_vm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/cs_xml_parser.o: ../../engine/tiscript/int/cs_xml_parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/terrascript.o: ../../engine/tiscript/terrascript/terrascript.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_eval_parser.o: ../../engine/tool/eval/tl_eval_parser.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_eval_vm.o: ../../engine/tool/eval/tl_eval_vm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux_specifics.o: ../../engine/tool/ports/linux_specifics.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/linux_spell_checker.o: ../../engine/tool/ports/linux_spell_checker.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/re.o: ../../engine/tool/re/re.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/snprintf.o: ../../engine/tool/snprintf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/snscanf.o: ../../engine/tool/snscanf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_async_io.o: ../../engine/tool/tl_async_io.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_base64.o: ../../engine/tool/tl_base64.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_basic.o: ../../engine/tool/tl_basic.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_crc32.o: ../../engine/tool/tl_crc32.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_datetime.o: ../../engine/tool/tl_datetime.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_filesystem.o: ../../engine/tool/tl_filesystem.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_lzf.o: ../../engine/tool/tl_lzf.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_mm_file.o: ../../engine/tool/tl_mm_file.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_sar.o: ../../engine/tool/tl_sar.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_string.o: ../../engine/tool/tl_string.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_tokenizer.o: ../../engine/tool/tl_tokenizer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_url.o: ../../engine/tool/tl_url.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_ustring.o: ../../engine/tool/tl_ustring.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_util.o: ../../engine/tool/tl_util.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_wregexp.o: ../../engine/tool/tl_wregexp.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/tl_zip.o: ../../engine/tool/tl_zip.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/ucdata_lt.o: ../../engine/tool/ucdata/ucdata_lt.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"
$(OBJDIR)/websockets.o: ../../engine/tool/websockets/websockets.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(ALL_CXXFLAGS) $(FORCE_INCLUDE) -o "$@" -MF "$(@:%.o=%.d)" -c "$<"

-include $(OBJECTS:%.o=%.d)
ifneq (,$(PCH))
  -include $(PCH_PLACEHOLDER).d
endif